<?php
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Filter\OutputFilter;

defined('_JEXEC') or die;
$app = Factory::getApplication();
$doc = $app->getDocument();
$config = $app->getConfig();
$debug = $config->get('debug', false) ? '' : '.min';
$width = 640;
$height = 360;
$attribs = 'class="ytnc-responsive ytnclazyload" style="--aspect-ratio:'.$width.'/'.$height.'"';
$doc->addStyleSheet(Uri::root(true) . '/media/plg_content_ytnocookies/css/ytnocookies'.$debug.'.css', array('version' => 'auto'));
$doc->addScript(Uri::root(true) . '/media/plg_content_ytnocookies/js/lazyloader' . $debug . '.js', array('version' => 'auto'));
$doc->addScriptDeclaration('ytnclazyloader = {"thumbnail":"hqdefault.jpg"};');
function video_id_from_url($url) {
    return explode("v=", $url)[1];
}
?>


<?php if (!empty($this->msg)) : ?>
    <?php echo $this->msg; ?>
<?php else : ?>
    <?php $lang      = $this->getLanguage(); ?>
    <?php $myrtl     = $this->item->rtl; ?>
    <?php $direction = ' '; ?>
    <?php $isRtl     = $lang->isRtl(); ?>
    <?php if ($isRtl && $myrtl == 0) : ?>
        <?php $direction = ' redirect-rtl'; ?>
    <?php elseif ($isRtl && $myrtl == 1) : ?>
        <?php $direction = ' redirect-ltr'; ?>
    <?php elseif ($isRtl && $myrtl == 2) : ?>
        <?php $direction = ' redirect-rtl'; ?>
    <?php elseif ($myrtl == 0) : ?>
        <?php $direction = ' redirect-ltr'; ?>
    <?php elseif ($myrtl == 1) : ?>
        <?php $direction = ' redirect-ltr'; ?>
    <?php elseif ($myrtl == 2) : ?>
        <?php $direction = ' redirect-rtl'; ?>
    <?php endif; ?>
    <?php $images = json_decode($this->item->images); ?>
    <div class="com-newsfeeds-newsfeed newsfeed<?php echo $direction; ?>">
        <?php if ($this->params->get('display_num')) : ?>
        <h1 class="<?php echo $direction; ?>">
            <?php echo $this->escape($this->params->get('page_heading')); ?>
        </h1>
        <?php endif; ?>
        <h2 class="<?php echo $direction; ?>">
            <?php if ($this->item->published == 0) : ?>
                <span class="badge bg-warning text-light"><?php echo Text::_('JUNPUBLISHED'); ?></span>
            <?php endif; ?>
            <a href="<?php echo $this->item->link; ?>" target="_blank" rel="noopener">
                <?php echo str_replace('&apos;', "'", $this->item->name); ?>
            </a>
        </h2>

        <?php if ($this->params->get('show_tags', 1)) : ?>
            <?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
            <?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
        <?php endif; ?>

        <!-- Show Images from Component -->
        <?php if (isset($images->image_first) && !empty($images->image_first)) : ?>
            <?php $imgfloat = empty($images->float_first) ? $this->params->get('float_first') : $images->float_first; ?>
            <div class="com-newsfeeds-newsfeed__first-image img-intro-<?php echo $this->escape($imgfloat); ?>">
                <figure>
                    <?php echo LayoutHelper::render(
                        'joomla.html.image',
                        [
                            'src' => $images->image_first,
                            'alt' => empty($images->image_first_alt) && empty($images->image_first_alt_empty) ? false : $images->image_first_alt,
                        ]
                    ); ?>
                    <?php if ($images->image_first_caption) : ?>
                        <figcaption class="caption"><?php echo $this->escape($images->image_first_caption); ?></figcaption>
                    <?php endif; ?>
                </figure>
            </div>
        <?php endif; ?>

        <?php if (isset($images->image_second) && !empty($images->image_second)) : ?>
            <?php $imgfloat = empty($images->float_second) ? $this->params->get('float_second') : $images->float_second; ?>
            <div class="com-newsfeeds-newsfeed__second-image float-<?php echo $this->escape($imgfloat); ?> item-image">
                <figure>
                    <?php echo LayoutHelper::render(
                        'joomla.html.image',
                        [
                            'src' => $images->image_second,
                            'alt' => empty($images->image_second_alt) && empty($images->image_second_alt_empty) ? false : $images->image_second_alt,
                        ]
                    ); ?>
                    <?php if ($images->image_second_caption) : ?>
                        <figcaption class="caption"><?php echo $this->escape($images->image_second_caption); ?></figcaption>
                    <?php endif; ?>
                </figure>
            </div>
        <?php endif; ?>
        <!-- Show Description from Component -->
        <?php echo $this->item->description; ?>
        <!-- Show Feed's Description -->

        <?php if ($this->params->get('show_feed_description')) : ?>
            <div class="com-newsfeeds-newsfeed__description feed-description">
                <?php echo str_replace('&apos;', "'", $this->rssDoc->description); ?>
            </div>
        <?php endif; ?>

        <!-- Show Image -->
        <?php if ($this->rssDoc->image && $this->params->get('show_feed_image')) : ?>
            <div class="com-newsfeeds-newsfeed__feed-image">
                <?php echo LayoutHelper::render(
                    'joomla.html.image',
                    [
                        'src' => $this->rssDoc->image->uri,
                        'alt' => $this->rssDoc->image->title,
                    ]
                ); ?>
            </div>
        <?php endif; ?>

        <!-- Show items -->
        <?php if (!empty($this->rssDoc[0])) : ?>
            <?php 
            $listMax = min($this->item->numarticles, count($this->rssDoc));
            for ($i = 0; $i < $listMax; $i++) : 
                $item = $this->rssDoc[$i];
                $video_id = video_id_from_url($item->uri);
                $embed_url = 'https://www.youtube-nocookie.com/embed/' . $video_id .'?modestbranding=1&showinfo=0&rel=0&autoplay=1';
                $content = $item->content !== '' ? '<p>' . trim($item->content) . '</p>' : '';
            ?>
                <div class="row"><div class="col">
                <h2><?php echo $item->title; ?></h2>
                <?php echo $content; ?>
                <div class="ytnc-fixed aspect aspect-4x3 m-5">
                    <div <?php echo $attribs; ?> data-ytncvideo="<?php echo $video_id; ?>" data-ytncembed="<?php echo $embed_url; ?>" data-ytncid="ytnc<?php echo $i; ?>" data-ytnctitle="<?php echo $item->title; ?>"></div>
                </div>
                <hr>
                </div></div>
            <?php endfor; ?>
        <?php endif; ?>
    <?php endif; ?>
