<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Content.logbadpasswords
 *
 * @copyright   (C) 2018 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace RicheyWeb\Plugin\User\LogBadPasswords\Field;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class BadpasswordsField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  3.9.1
     */
    protected $type = 'Badpasswords';

    /**
     * Method to get the field label markup.
     *
     * @return  string  The field label markup.
     *
     * @since   3.3.7
     */
    protected function getInput() {
		// Initialize some field attributes.
		$size = $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '';
		$maxLength = $this->element['maxlength'] ? ' maxlength="' . (int) $this->element['maxlength'] . '"' : '';
		$class = $this->element['class'] ? ' class="' . (string) $this->element['class'] . '"' : '';
		$readonly = ((string) $this->element['readonly'] == 'true') ? ' readonly="readonly"' : '';
		$disabled = ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';

		// Initialize JavaScript field attributes.
		$onchange = $this->element['onchange'] ? ' onchange="' . (string) $this->element['onchange'] . '"' : '';

		$input = '<ul class="d-block clearfix">';
        if(strlen($this->value)) {
            foreach(explode(', ',$this->value) as $value) $input.='<li>'.$value.'</li>';
            $buttondisabled=false;
        } else {
            $input.='<li style="color:#ff0000">'.Text::_('PLG_USER_LOGBADPASSWORDS_NONE_STORED').'</li>';
            $buttondisabled=true;
        }
        $input.= '</ul>';
        if(!$buttondisabled) $input.= '<button'.$buttondisabled.' style="clear:left;" onclick="document.getElementById(\''.$this->id.'\').value=\'\';this.disabled=true;this.innerText = \''.Text::_('PLG_USER_LOGBADPASSWORDS_CLEARED').'\';return false;">'.Text::_('PLG_USER_LOGBADPASSWORDS_CLEAR').'</button>';
        $input.= '<input type="hidden" name="' 
            . $this->name . '" id="' . $this->id . '"' 
            . ' value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') 
            . '"' . $class . $size . $disabled . $readonly . $onchange . $maxLength 
        . '/>';
        return $input;        
    }
}