<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Content.sessionkeeper
 *
 * @copyright   (C) 2018 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\User\AuthLog\Field;
use Joomla\CMS\Form\FormField;
use Joomla\Plugin\User\AuthLog\Extension\AuthLogHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class AuthlogField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  3.9.1
     */
    protected $type = 'Text';

    /**
     * Method to get the field label markup.
     *
     * @return  string  The field label markup.
     *
     * @since   3.3.7
     */
    protected function getInput() {
        $user_id = $this->form->getData()->get('id');
        if ($user_id == 0) {
            return '';
        }
        return AuthLogHelper::display($user_id);
    }
}