<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\XAutopost\XMetas;

\defined('_JEXEC') or die;

class XMeta_com_content extends XMeta {
    public function getDescription() {
        $option = $this->articleCard->get('description_option','default');
        if($option === 'default'){
            $option = $this->defaultCard->get('description_option','meta');
        }
        switch($option){
            case 'meta':
                if(!empty($this->article->metadesc)){
                    return $this->compressTrimText($this->article->metadesc,280);
                }
                break;
            case 'text':
                if(!empty($this->article->introtext) || !empty($this->article->fulltext)){
                    return $this->compressTrimText(strip_tags($this->article->introtext.$this->article->fulltext),280);
                }
                break;
            case 'custom':
                if($this->articleCard->get('description',false)){
                    return $this->compressTrimText($this->articleCard->get('description',false),280);
                }
                break;
        }
        return $this->compressTrimText($this->app->getConfig()->get('MetaDesc',false),280);
    }
    public function getTitle() {
        $option = $this->articleCard->get('title_option','default');
        if($option === 'default'){
            $option = 'title'; // always use title if default
        }
        switch($option){
            case 'title':
                return $this->article->title;
            case 'custom':
                if($this->articleCard->get('title',false)){
                    return $this->articleCard->get('title',false);
                }
                break;
        }
    }
    public function getImagePath() {
        $option = $this->articleCard->get('image_option','default');
        if($option === 'default'){
            $option = $this->defaultCard->get('image_option','any');
        }
        $articleImages = json_decode($this->article->images);
        switch($option){
            case 'any':                
                if(!empty($articleImages->image_fulltext)){
                    $fulltext = explode('#',$articleImages->image_fulltext)[0];
                    if($this->validImage($fulltext)){
                        return $fulltext;
                    }
                }
                if(!empty($articleImages->image_intro)){
                    $intro = explode('#',$articleImages->image_intro)[0];
                    if($this->validImage($intro)){
                        return $intro;
                    }
                }
                $articleImage = $this->articleImage($this->article->introtext.$this->article->fulltext);
                if($articleImage !== false){
                    return $articleImage;
                }
                break;
            case 'intro':
                if(!empty($articleImages->image_intro)){
                    $intro = explode('#',$articleImages->image_intro)[0];
                    if($this->validImage($intro)){
                        return $intro;
                    }
                }
                break;
            case 'full':                
                if(!empty($articleImages->image_fulltext)){
                    $fulltext = explode('#',$articleImages->image_fulltext)[0];
                    if($this->validImage($fulltext)){
                        return $fulltext;
                    }
                }
                break;
            case 'custom':
                $custom = $this->articleCard->get('image',false); 
                $custom = explode('#',$custom)[0];               
                if($custom && $this->validImage($custom)){
                    return $custom;
                }
                break;
        }
        $fallback = $this->defaultCard->get('fallback_image',false);
        $fallback = explode('#',$fallback)[0];
        return $this->validImage($fallback) ? $fallback : false;
    }
    public function getImage_alt() {
        $option = $this->articleCard->get('image_alt_option','default');
        if($option === 'default'){
            $option = $this->defaultCard->get('image_alt_option','title');
        }
        switch($option){
            case 'title':
                return $this->compressTrimText($this->article->title,420);
                break;
            case 'intro':
                if(!empty($this->article->introtext)){
                    return $this->compressTrimText(strip_tags($this->article->introtext),420);
                }
                break;
            case 'full':
                if(!empty($this->article->fulltext)){
                    return $this->compressTrimText(strip_tags($this->article->fulltext),420);
                }
                break;
            case 'custom':
                if($this->articleCard->get('image_alt',false)){
                    return $this->compressTrimText($this->articleCard->get('image_alt',false),420);
                }
                break;
        }
        return $this->compressTrimText($this->app->getConfig()->get('MetaDesc',false),200);
    }
    public function getApp_country() {
        $rv = strtoupper($this->articleCard->get('app_country',false));
        if(preg_match('/^[A-Z]{2}$/',$rv)){
            return $rv;
        }
        return 'US';
    }
    public function getApp_name_iphone() {
        $rv = $this->articleCard->get('app_name_iphone',false);
        return $rv;
    }
    public function getApp_id_iphone() {
        return $this->articleCard->get('app_id_iphone',false);
    }
    public function getApp_url_iphone() {
        return $this->articleCard->get('app_url_iphone',false);
    }
    public function getApp_name_ipad() {
        return $this->articleCard->get('app_name_ipad',false);
    }
    public function getApp_id_ipad() {
        return $this->articleCard->get('app_id_ipad',false);
    }
    public function getApp_url_ipad() {
        return $this->articleCard->get('app_url_ipad',false);
    }
    public function getApp_name_googleplay() {
        return $this->articleCard->get('app_name_googleplay',false);
    }
    public function getApp_id_googleplay() {
        return $this->articleCard->get('app_id_googleplay',false);
    }
    public function getApp_url_googleplay() {
        return $this->articleCard->get('app_url_googleplay',false);
    }
    public function getPlayer() {
        // Validate URL
        $rv = $this->articleCard->get('player',false);
        return filter_var($rv, FILTER_VALIDATE_URL) ? $rv : false;
    }
    public function getPlayer_width() {
        // first we cast to int to avoid weird strings
        // then we cast back to string because meta content must be string
        $rv = (int)$this->articleCard->get('player_width',false);
        return (string)$rv;
    }
    public function getPlayer_height() {
        // first we cast to int to avoid weird strings
        // then we cast back to string because meta content must be string
        $rv = (int)$this->articleCard->get('player_height',false);
        return (string)$rv;
    }
    public function getStream() {
        // Validate URL
        $rv = $this->articleCard->get('player_stream',false);
        if(filter_var($rv, FILTER_VALIDATE_URL)){
            return $rv;
        }
        if(!file_exists(JPATH_ROOT.'/'.$rv)){
            return false;
        }
        // now we prepend the base url
        $base = $this->getBaseUrl();
        return $base.ltrim($rv,'/');
    }
}