const VoiceSearchClass = function(options) {
    const root = this;
    this.recognizer = null;
    this.vars = {
        button: null,
        buttonclass: 'btn btn-success',
        buttonicon:null,
        buttontext:'PLG_SYSTEM_VOICESEARCH_LISTEN',
        buttonlisteningclass:'btn btn-error',
        buttonlisteningicon:null,
        buttonlisteningtext:'PLG_SYSTEM_VOICESEARCH_LISTENSTOP',
        container: null,
        continuous: false,
        confidence: 0.9,
        interrimResults: true,
        autosubmit: 1,
        position: 'before',
        debug: 0
    };
    const construct = function(options){
        // SpeechRecognition only works in https, unless browser flags are set
        // if (location.protocol !== 'https:') {
        if (!window.isSecureContext) {
            console.error('SpeechRecognition only works in https');
            return;
        }
        // check browser support, this eliminates chrome based browsers that do not support speech recognition
        let supported = root.isSupported();
        if(!supported) {
            console.error('SpeechRecognition is not supported');
            return;
        }
        // this secondary support test determines if the browser supports the speech recognition API, 
        // some supported browsers may not support the API
        let voicesearch = true;
        try {
            window.SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition || null;
            if ([null,undefined].indexOf(window.SpeechRecognition) !== -1) {
                // throw {message:'SpeechRecognition is not supported',name:'speechException'};
                throw new Error('SpeechRecognition is not supported');
            }
        } catch(e) {
            console.error(e);
            voicesearch = false;
        }
        if(!voicesearch) {
            return;
        }
        Object.assign(root.vars, options);
        root.recognizer = new window.SpeechRecognition();
        root.recognizer.lang = root.vars.lang;
        root.recognizer.continuous = root.vars.continuous;
        root.recognizer.interimResults = root.vars.interrimResults;
        root.recognizer.addEventListener('result',function(event) {
            console.log(event);
            let minconfidence = 1;
            let result = [];
            for (var i = event.resultIndex; i < event.results.length; i++) {
                minconfidence = (event.results[i][0].confidence < minconfidence) ? event.results[i][0].confidence : minconfidence;
                result.push(event.results[i][0].transcript);
            }
            if(minconfidence < root.vars.confidence) {
                root.vars.container.value = result.join(' ').replace(/[.!?]+$/,'');
                Joomla.renderMessages({'warning':[Joomla.Text._('PLG_SYSTEM_VOICESEARCH_LOWCONFIDENCE')]},'#system-message-container',null,3000);
            } else {
                // strip punctuation from the end of the result (.!?)
                root.vars.container.value = result.join(' ').replace(/[.!?]+$/,'');
                if(root.vars.autosubmit) {
                    root.vars.container.form.submit();
                }
            }
        });
        root.recognizer.addEventListener('error',function(event) {
            console.log(`Speech recognition error detected: ${event.error}`);
            console.log(`Additional information: ${event.message}`);
        });
        if(root.vars.debug) {
            root.recognizer.addEventListener('start',function(event) {
                console.log('Recognition started');
            });
            root.recognizer.addEventListener('end',function(event) {
                console.log('Recognition ended');
            });
            root.recognizer.addEventListener('audiostart',function(event) {
                console.log('Audio started');
            });
            root.recognizer.addEventListener('audioend',function(event) {
                console.log('Audio ended');
            });
            root.recognizer.addEventListener('speechstart',function(event) {
                console.log('Speech started');
            });
            root.recognizer.addEventListener('speechend',function(event) {
                console.log('Speech ended');
            });
        }
        root.createStartStopButton();
    }
    this.isSupported = function(){
        let supportedBrands = ['Google Chrome','Microsoft Edge','Opera'];
        let unsupportedBrands = ['Brave','Chromium'];
        let supported = true;
        // first we test the unsupported brands, because there is crossover with the supported brands
        let isUnsupported = unsupportedBrands.some(function(browser){
            return navigator.userAgentData.brands.some(data=>data.brand == browser);
        });
        if(isUnsupported) {
            // unsupported brand detected, set supported to false
            supported = false;
            // now we test the supported brands and determine if there is crossover
            let isSupported = false;
            isSupported = supportedBrands.some(function(browser){
                return navigator.userAgentData.brands.some(data=>data.brand == browser);
            });
            if(isSupported) {
                // supported brand detected, set supported to true
                supported = true;
            }
        }   
        return supported;     
    }
    this.createStartStopButton = function() {
        let inputGroup = document.createElement('div');
        inputGroup.className = 'input-group';
        root.vars.container.parentNode.insertBefore(inputGroup, root.vars.container);
        inputGroup.appendChild(root.vars.container);

        root.vars.button = document.createElement('button');
        root.vars.button.title = Joomla.Text._('PLG_SYSTEM_VOICESEARCH_BUTTON_TITLE');
        root.addClasses(root.vars.button, root.vars.buttonclass);
        root.vars.button.dataset.recording = false;
        if(root.vars.buttonicon.length) {
            let icon = document.createElement('i');
            root.addClasses(icon, root.vars.buttonicon);
            root.vars.button.appendChild(icon);
        }
        if(root.vars.buttontext.length) {
            let span = document.createElement('span');
            span.innerText = Joomla.Text._(root.vars.buttontext);
            root.vars.button.appendChild(span);
        }
        root.vars.button.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            root.toggleStartStop();
        });
        root.vars.container.addEventListener('keydown', function(e) {
            if(e.keyCode == 13 || e.which == 13) {
                e.preventDefault();
                e.stopPropagation();
                this.form.submit();
            }
        });
        switch(root.vars.position) {
            case 'before':
                inputGroup.insertBefore(root.vars.button, root.vars.container);
                break;
            case 'after':
            default:
                inputGroup.appendChild(root.vars.button);
                break;
        }
    }
    this.toggleStartStop = function() {
        switch(root.vars.button.dataset.recording) {
            case 'true':
                try {
                    root.recognizer.stop();
                    root.vars.button.dataset.recording = false;
                    root.swapClasses(root.vars.button, root.vars.buttonlisteningclass, root.vars.buttonclass);
                    if(root.vars.buttonicon.length) {
                        let icon = root.vars.button.querySelector('i');
                        root.swapClasses(icon, root.vars.buttonlisteningicon, root.vars.buttonicon);
                    }
                    if(root.vars.buttontext.length){
                        let span = root.vars.button.querySelector('span');
                        if(span){
                            span.innerText = Joomla.JText._(root.vars.buttontext);
                        }
                    }
                } catch(ex){
                    console.log('Recognition error: ' + ex.message);
                }
                break;
            case 'false':
            default:
                try {
                    root.recognizer.start();
                    root.vars.button.dataset.recording = true;
                    root.swapClasses(root.vars.button, root.vars.buttonclass, root.vars.buttonlisteningclass);
                    if(root.vars.buttonlisteningicon.length) {
                        let icon = root.vars.button.querySelector('i');
                        root.swapClasses(icon, root.vars.buttonicon, root.vars.buttonlisteningicon);
                    }
                    if(root.vars.buttonlisteningtext.length){
                        let span = root.vars.button.querySelector('span');
                        if(span){
                            span.innerText = Joomla.JText._(root.vars.buttonlisteningtext);
                        }
                    }
                } catch(ex){
                    console.log('Recognition error: ' + ex.message);
                }
                break;
        }
    }
    this.swapClasses = function (element, oldClasses, newClasses){
        root.removeClasses(element, oldClasses);
        root.addClasses(element, newClasses);
    }
    this.addClasses = function (element, classes) {
        if (element === undefined || classes === undefined) {
            return;
        }
        if (typeof classes === 'string') {
            classes = classes.split(' ');
        }
        classes.forEach(function (cls) {
            element.classList.add(cls);
        });
    };
    this.removeClasses = function (element, classes) {
        if (element === undefined || classes === undefined) {
            return;
        }
        if (typeof classes === 'string') {
            classes = classes.split(' ');
        }
        classes.forEach(function (cls) {
            element.classList.remove(cls);
        });
    };
    // this.element = function (raw) {
    //     return (raw !== undefined && raw === true) ? root.vars.container : document.querySelector(root.vars.container);
    // };
    // this.uid = function () {
    //     return root._uid().replace(/[/,'').replace(/]/, "").replace(/:/, "");
    // };
    // this._uid = function () {
    //     if (root.element().attr("id")) {
    //         return root.element().attr("id");
    //     }
    //     if (root.element().attr("name")) {
    //         return root.element().attr("name");
    //     }
    //     var a = "";
    //     if (root.element(true).form.id) {
    //         a = root.element(true).form.id;
    //     }
    //     if (!a && root.element(true).form.name) {
    //         a = root.element(true).form.name;
    //     }
    //     return a + root.element().index();
    // };
    // this.speechException = function(message) {
    //     this.message = message;
    //     this.name = 'speechException';
    // };
    construct(options);
}

window.addEventListener('DOMContentLoaded', function() {
    let plg_system_voicesearch_options = Joomla.getOptions('plg_system_voicesearch');
    plg_system_voicesearch_options.targets.forEach(function(target){
        var targetList = document.querySelectorAll(target);
        if(targetList.length){
            targetList.forEach(function(element){
                const options = {};
                Object.assign(options, plg_system_voicesearch_options);
                options.container = element;
                const api = new VoiceSearchClass(options);
                element.voiceSearchApi = api;
            });
        }
    });
});

// document.querySelectorAll('[data-voice-search]').forEach(function(element) {
//     const options = {
//         container: element
//     };
//     const api = new VoiceSearchClass(options);
//     element.voiceSearchApi = api;
// });


