<?php

/**
 * @package plugin Nomad Pro
 * @copyright (C) 2012-2017 RicheyWeb - www.richeyweb.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Nomad Pro Copyright (c) 2017 Michael Richey.
 * Nomad Pro is licensed under the http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

/**
 * Nomad Pro system plugin
 */
class plgSystemNomadPro extends JPlugin
{
	private $menu;
	private $current;
	private $home;
	private $doredirect = false;

	function onAfterRoute() {
		$this->getMenu();
		if (!$this->_run() || $this->current->id != $this->home->id)
		{
			return true;
		}
		/* pro feature start */
		if ($userrules = array_filter((array) $this->params->get('userrules', array()), array($this, 'filterUser')))
		{
			$firstrule = array_shift($userrules);
			$this->doredirect = $firstrule->homepage;
			return true;
		}
		if ($grouprules = array_filter((array) $this->params->get('grouprules', array()), array($this, 'filterGroup')))
		{
			$firstrule = array_shift($grouprules);
			$this->doredirect = $firstrule->homepage;
			return true;
		}
		/* pro feature end */
		$this->doredirect = $this->params->get('homepage', $this->home->id);
		return true;
	}
	
	public function onBeforeCompileHead() {
		if($this->doredirect) {
			$this->redirect($this->doredirect);
		}
		return true;
	}

	private function getMenu() {
		$app = JFactory::getApplication();
		$this->menu = $app->getMenu();
		$this->home = $this->menu->getDefault();
		$this->current = $this->menu->getActive();
	}

	private function redirect($id) {
		$app = JFactory::getApplication();
		if ($id === $this->home->id?:false || $id === $this->current->id?:false)
		{
			return true;
		}
		$menuitem = $this->menu->getItem($id);
		if ($menuitem->type === 'alias')
		{
			return $this->redirect($menuitem->params->get('aliasoptions'));
		}
		return $app->redirect(JRoute::_($menuitem->link . '&Itemid=' . $id, false));
	}
	
	private function _run() {
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$user = JFactory::getUser();
		return ($app->isSite() && $user->id && $doc->getType() === 'html');
	}

	/* pro feature start */

	private function filterUser($element) {
		$user = JFactory::getUser();
		return (int) $element->user === (int) $user->id;
	}

	private function filterGroup($element) {
		$user = JFactory::getUser();
		return count(array_intersect($user->groups, $element->groups));
	}

	/* pro feature end */
}
