<?php

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Exception\FilesystemException;
// use Joomla\CMS\Cache\CacheController;
// use Joomla\CMS\Cache\CacheControllerFactoryInterface;
// use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

return new class () implements ServiceProviderInterface {
  public function register(Container $container)
  {
    $container->set(
      InstallerScriptInterface::class,
      new class (
      $container->get(AdministratorApplication::class),
      $container->get(DatabaseInterface::class)
      ) implements InstallerScriptInterface {
        // private AdministratorApplication $app;
        // private DatabaseInterface $db;

        // public function __construct(AdministratorApplication $app, DatabaseInterface $db)
        // {
        //   $this->app = $app;
        //   $this->db  = $db;
        // }

        public function install(InstallerAdapter $parent): bool
        {
          $this->copyTemplate();
          return true;
        }

        public function update(InstallerAdapter $parent): bool
        {
          $this->copyTemplate();
          return true;
        }

        public function uninstall(InstallerAdapter $parent): bool
        {
          return true;
        }

        public function preflight(string $type, InstallerAdapter $parent): bool
        {
          return true;
        }

        public function postflight(string $type, InstallerAdapter $parent): bool
        {
          return true;
        }

        private function copyTemplate(){
          $source = __DIR__ . '/markdown.php';
          $destination = JPATH_ROOT .'/templates/system/markdown.php';
          try {
            if (!File::exists($destination)) {
              File::copy($source, $destination);
            }
          } catch (FilesystemException $e) {
            $this->app->enqueueMessage(Text::sprintf('PLG_SYSTEM_MARKDOWN_TEMPLATE_COPY_FAILED', $e->getMessage()), 'error');
          }
        }
      }
    );
  }
};

