<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Content\Site\Helper\RouteHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_content extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $url = false;
        $valid = ['start'=>'int'];
        switch($vars['view']){
            case 'article':
                $valid += ['limit'=>'int','limitstart'=>'int','showall'=>'bool'];
                $catid = isset($vars['catid'])?(int)$vars['catid']:null;
                $url = RouteHelper::getArticleRoute((int)$vars['id'], $catid);
                break;
            case 'featured':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\FeaturedModel');
                $pagination = self::setPagination($pObject);
                self::paginationStartFix($vars,$pagination);
                $url = 'index.php?option=com_content&view=featured';
                break;
            case 'archive':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\ArchiveModel');
                $pagination = self::setPagination($pObject);
                self::paginationStartFix($vars,$pagination);
                $url = 'index.php?option=com_content&view=archive';
                if(count($vars['catid']??[])){
                    $url .= self::queryFromArray('catid',(int)$vars['catid']??[],'&');
                }
                break;
            case 'category': 
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\CategoryModel');
                $pagination = self::setPagination($pObject);
                self::paginationStartFix($vars,$pagination);
                $valid += ['layout'];
                $url =  RouteHelper::getCategoryRoute((int)$vars['id']);
                break;
            case 'categories':
                $valid += ['id'=>'int'];
                $url = 'index.php?option=com_content&view=categories';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if(!$url) {
            return false;
        }
        if(!is_array($valid)){
            return $url;
        }
        if(count($valid)){
            if(!$pagination) {
                unset($vars['start']);
            } else {
                if($pagination[3] > 0 && isset($vars['start'])){
                    if($vars['start'] > $pagination[3]){
                        $vars['start'] = $pagination[3];
                    }
                }
            }
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }


}