<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

// use Akeeba\Component\ARS\Site\Service\Router;


// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_ars extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $valid = [
            'start'=>'int'
        ];
        $url = false;
        switch($vars['view']){
            case 'categories':
                // $pObject = self::getCategoryPaginationObject('\Akeeba\Component\ARS\Site\Model\CategoriesModel');
                // $pagination = self::setPagination($pObject);
                $valid += ['layout'=>'string'];
                $url = 'index.php?option=com_ars&view=categories';
                // we were previously assuming an id meant category_id, but it could be something else
                // if it is something else, it will be removed by the invalids array above
                unset($vars['id']);
                // if(isset($vars['id'])){
                //     $url = 'index.php?option=com_ars&view=releases';
                //     $url .= '&id='.((int)$vars['id']);
                // }
                break;
            case 'releases':
                // $pObject = self::getCategoryPaginationObject('\Akeeba\Component\ARS\Site\Model\ReleasesModel');
                // $pagination = self::setPagination($pObject);
                // $valid += ['category_id'];
                $url = 'index.php?option=com_ars&view=releases';
                if(isset($vars['category_id'])){
                    $url .= '&category_id='.((int)$vars['category_id']);
                }
                break;
            case 'dlidlabels':
                // $pObject = self::getCategoryPaginationObject('\Akeeba\Component\ARS\Site\Model\DlidlabelsModel');
                // $pagination = self::setPagination($pObject);
                $url = 'index.php?option=com_ars&view=dlidlabels';
                break;
            case 'items':
                // $pObject = self::getCategoryPaginationObject('\Akeeba\Component\ARS\Site\Model\ItemsModel');
                // $pagination = self::setPagination($pObject);
                $valid += ['category_id'=>'int','release_id'=>'int','layout'=>'string'];
                $url = 'index.php?option=com_ars&view=items';
                break;
            case 'latest':
                $url = 'index.php?option=com_ars&view=latest&layout=latest';
                break;
        }

        // // if we have a route and valid extra vars, add the extra vars
        if($url && count($valid)){
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }
}