<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Newsfeeds\Site\Helper\RouteHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_newsfeeds extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $valid = ['start'=>'int'];
        $url = false;
        switch($vars['view']){
            case 'newsfeed':
                $url = RouteHelper::getNewsfeedRoute((int)$vars['id'], (int)$vars['catid']??1, (string)$vars['lang']??'*');
                break;
            case 'category':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Newsfeeds\Site\Model\CategoryModel');
                $pagination = self::setPagination($pObject);
                self::paginationStartFix($vars,$pagination);
                $url = RouteHelper::getCategoryRoute((int)$vars['id'], (string)$vars['lang']??'*');
                break;
            case 'categories':
                $valid += ['id'=>'int'];
                $url = 'index.php?option=com_newsfeeds&view=categories';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if($url && count($valid)){
            if(!$pagination) {
                unset($vars['start']);
            } else {
                if($pagination[3] > 0){
                    if($vars['start'] > $pagination[3]){
                        $vars['start'] = $pagination[3];
                    }
                }
            }
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }
}