<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Tags\Site\Helper\RouteHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_finder extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $valid = [];
        $url = false;

        switch($vars['view']){
            case 'search':
                $queryParameterList = [
                    'f'  => 'int',
                    't'  => 'array',
                    'q'  => 'string',
                    'l'  => 'cmd',
                    'd1' => 'string',
                    'd2' => 'string',
                    'w1' => 'string',
                    'w2' => 'string',
                    'o'  => 'word',
                    'od' => 'word',
                ];
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Finder\Site\Model\SearchModel');
                $pagination = self::setPagination($pObject,$queryParameterList);
                self::paginationStartFix($vars,$pagination);
                $url = 'index.php?option=com_finder&view=search';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if($url && count($valid)){
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }
}