<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Tags\Site\Helper\RouteHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Version;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_tags extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $valid = ['start'=>'int'];
        $url = false;
        switch($vars['view']){
            case 'tag':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Tags\Site\Model\TagModel');
                $pagination = self::setPagination($pObject);
                $valid += ['layout'=>'string'];
                // I hate to do this, but the router changed in 5.3.0 - which simplifies the code
                // but makes it incompatible with 5.2.x which requires a heavier solution
                // so we need to check the version and use the new router if available
                $version = new Version();
                $newrouter = $version->isCompatible('5.3.0')?true:false;
                if(count($vars['id']) === 1){
                    if($newrouter){
                        // new hotness
                        $language = Factory::getLanguage()->getTag();
                        $url = RouteHelper::getComponentTagRoute((int)$vars['id'][0],$language);
                    } else {
                        // old and busted
                        $model = new \Joomla\Component\Tags\Site\Model\TagModel();
                        $tags = $model->getItem((int)$vars['id'][0]);
                        if(count($tags)){
                            $tag = $tags[0];
                            $url = RouteHelper::getComponentTagRoute($tag->id.':'.$tag->alias,$tag->language);
                        }   
                    }                 
                } else {
                    $url = 'index.php?option=com_tags&view=tag';
                    foreach($vars['id']??[] as $i=>$id){
                        $url .= '&id['.(int)$i.']='.(int)$id;
                    }
                }
                foreach($vars['types']??[] as $i=>$type){
                    $url .= '&types['.(int)$i.']='.$type;
                }
                break;
            case 'tags':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Tags\Site\Model\TagsModel');
                $pagination = self::setPagination($pObject);
                $valid += ['parent_id'=>'int'];
                $url = 'index.php?option=com_tags&view=tags';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if($url && count($valid)){
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }

}