<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Content\Site\Helper\RouteHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_content extends LinkCanonicalFix {
    public static function fix(&$vars,$uri,&$pagination=false)
    {
        $url = false;
        $valid = ['start','abc'];
        switch($vars['view']){
            case 'article':
                $valid += ['limit','limitstart','showall'];
                $url = RouteHelper::getArticleRoute((int)$vars['id'], (int)$vars['catid']??null);
                break;
            case 'featured':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\FeaturedModel');
                $pagination = self::setPagination($pObject);
                $url = 'index.php?option=com_content&view=featured';
                break;
            case 'archive':
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\ArchiveModel');
                $pagination = self::setPagination($pObject);
                $url = 'index.php?option=com_content&view=archive';
                if(count($vars['catid']??[])){
                    $url .= self::queryFromArray('catid',(int)$vars['catid']??[],'&');
                }
                break;
            case 'category': 
                $pObject = self::getCategoryPaginationObject('\Joomla\Component\Content\Site\Model\CategoryModel');
                $pagination = self::setPagination($pObject);
                $valid += ['layout'];
                $url =  RouteHelper::getCategoryRoute((int)$vars['id']);
                break;
            case 'categories':
                $valid += ['id'];
                $url = 'index.php?option=com_content&view=categories';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if(!$url) {
            return false;
        }
        if(!is_array($valid)){
            return $url;
        }
        if(count($valid)){
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }


}