<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.globalprivacycontrol
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\GlobalPrivacyControl\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\User\User;
use Joomla\CMS\Language\Text;
use ReflectionClass;
use ReflectionProperty;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
final class GlobalPrivacyControl extends CMSPlugin
{
    protected $app;
    protected $autoloadLanguage = true;
    private $cookieconsent = null;
    private $_GPC=0;
    private $_trackingACL=false;
    private $consent = null;

    public function onAfterInitialise() {
        
        // we don't run in /administrator
        $this->app = Factory::getApplication();
        if($this->app->isClient('administrator')) return true;

        // we don't run if there's no trackingACL set
        $this->_trackingACL = $this->params->get('trackingACL',false);
        if($this->_trackingACL===false) return true;

        // we don't run if the server doesn't support ReflectionClass or ReflectionProperty
        if(!class_exists('ReflectionClass',false) || !method_exists('ReflectionProperty','setAccessible')) return true;
        
        $this->_GPC = getenv('HTTP_SEC_GPC')?1:0;
         
        $cookieconsentString = $this->app->input->cookie->getString('plg_system_globalprivacycontrol_consent','{}')??'{}';  
        $this->cookieconsent = json_decode($cookieconsentString,true);

        $user = $this->app->getIdentity();
        $authLevels = $user->getAuthorisedViewLevels();

        if($this->cookieconsent['global_privacy_control']??false === 'granted') {
            $this->_consent($user,$authLevels);
            return true;
        }

        if($this->_GPC || ($this->cookieconsent['global_privacy_control']??false) === 'denied') {
            $this->_nonconsent($user,$authLevels);
        } else {
            $this->_consent($user,$authLevels);
        }
        return true;
    }

    public function onBeforeRender() {
        // Code to execute after the page has been rendered
        $doc = $this->app->getDocument();
        if ($doc->getType() !== 'html') {
            return true;
        }
        $this->consent = ['global_privacy_control'=>((bool)($this->cookieconsent?:!$this->_GPC))?'granted':'denied'];
        $this->registerConsentOptions($doc);
    }

    // public function onBeforeCompileHead() {
    public function registerConsentOptions($doc) {
        if($this->app->isClient('administrator')) return true;
        $registerconsent = $doc->getScriptOptions('plg_system_eprivacy',[]);
        $registerconsent['plg_system_globalprivacycontrol'] = ['consent'=>$this->consent];
        $doc->addScriptOptions('plg_system_eprivacy', $registerconsent);
        Text::script('PLG_SYSTEM_GLOBALPRIVACYCONTROL_SCRIPT');
        Text::script('PLG_SYSTEM_GLOBALPRIVACYCONTROL_SCRIPT_GLOBAL_PRIVACY_CONTROL');
        Text::script('PLG_SYSTEM_GLOBALPRIVACYCONTROL_SCRIPT_GLOBAL_PRIVACY_CONTROL_DESC');
    }

    private function _consent(&$user,$authLevels) {
        if(!in_array($this->_trackingACL,$authLevels)) {
            $this->_adjustViewLevel($user,$authLevels);
        }        
    }

    private function _nonconsent(&$user,$authLevels) {
        // it needs to be a test, because we need the key to not be false
        // this only runs if there's an actual key value
        $key = array_search($this->_trackingACL,$authLevels);
        if($key !== false) { 
            $this->_adjustViewLevel($user,$authLevels,$key);
        }
    }

    // Joomla gives no other method to manipulate access levels on-the-fly
    // so we have to use ReflectionClass to do it - you can't stop the signal

    function _adjustViewLevel(&$user,$authLevels,$remove=false) {
        $AuthLevelsReflection = new ReflectionClass('Joomla\CMS\User\User');
        $_authLevels = $AuthLevelsReflection->getProperty('_authLevels');
        $_authLevels->setAccessible(true);  
        if($remove === false) {
            $authLevels[]=$this->_trackingACL;  
        } else {
            unset($authLevels[$remove]);
        }
        $_authLevels->setValue($user,$authLevels);
    }
}