<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.metarobots
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\ExternalLinkWarning\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
final class ExternalLinkWarning extends CMSPlugin
{

    /**
     * Load the language file on instantiation.
     *
     * @var    bool
     * @since  4.4.0
     */
    protected $autoloadLanguage = true;

    public function onBeforeCompileHead()
    {
        $app = Factory::getApplication();
        if(!$app->isClient('site')) {
            return;
        }
        $doc = $app->getDocument();
        if($doc->getType() !== 'html') {
            return;
        }
        $debug = $app->get('debug', 0);
        Text::script('PLG_SYSTEM_EXTERNALLINKWARNING_WARNING_MESSAGE');

        $options = [
            'sitename' => $app->get('sitename'),
            'warningexcludeclasses' => $this->params->get('warningexcludeclasses', '{"classes":[]}'),
            'warningexcludedomains' => $this->params->get('warningexcludedomains', '{"domains":[]}'),
            'linkclass' => $this->params->get('linkclass', ''),
            'uselinkicon' => $this->params->get('uselinkicon', 0),
            'linkicon' => $this->params->get('linkicon', ''),
            'linkiconexcludeclasses' => $this->params->get('linkiconexcludeclasses', '{"classes":[]}'),
            'newtab' => $this->params->get('newtab', 0),
        ];
        $doc->addScriptOptions('plg_system_externallinkwarning', $options);
        $doc->addScript(Uri::root(true) . '/media/plg_system_externallinkwarning/js/externallinkwarning' . ($debug ? '' : '.min') . '.js');
    }
}