var plg_system_externallinkwarningClass = function(options){
    var root = this;
    var vars = {
        hostname:null,
        options:{
            sitename:false,
            warningexcludeclasses:[],
            warningexcludedomains:[],
            uselinkicon:false,
            linkicon:'',
            linkiconexcludeclasses:[]
        }
    };
    var construct = function(options){
        var parse = {
            warningexcludeclasses:'classes',
            warningexcludedomains:'domains',
            linkiconexcludeclasses:'classes'
        };
        for(var key in options){
            if(parse[key]){
                Object.getOwnPropertyNames(options[key]).forEach(function(subkey){
                    vars.options[key].push(options[key][subkey][parse[key]]);
                });
            } else {
                vars.options[key] = options[key];
            }
        }

        vars.hostname = window.location.hostname;
        let links = findLinks();
        if(options.uselinkicon) {
            markLinks(links);
        }
    }

    var getHostname = function(url){
        var s = document.createElement("a");
        s.href = url;
        return s.hostname;
    };

    var findLinks = function(){
        let links = [];
        var domain, proc, classes;
        let a = document.getElementsByTagName('a');
        Array.from(a).forEach((link) => {
            domain = getHostname(link.href);
            classes = link.className.split(/\s+/);
            // href does not begin with 'javascript', domain is not the same as vars.hostname, not in exclude domains, not in exclude classes
            if(
                link.href.trim().indexOf('javascript') !== 0 && 
                domain !== vars.hostname && 
                vars.options.warningexcludedomains.indexOf(domain) === -1 && 
                !classes.some(r => vars.options.warningexcludeclasses.indexOf(r) >= 0)
            ){
                links.push(link);
                link.addEventListener('click', function(e){
                    e.preventDefault();
                    e.stopPropagation();
                    linkWarning(link.href);
                });
            }
        });
        return links;
    }

    var markLinks = function(links){
        links.forEach(function(link){
            // skip if link does not contain ONLY text
            if(link.childNodes.length > 1){
                console.log('skipping icon');
                return;
            }
            // check intersect between link.classlist and linkiconexcludeclasses
            if(!link.classList.contains(vars.options.linkiconexcludeclasses)){
                var span = document.createElement('span');
                span.className = vars.options.linkicon;
                // prepend the icon to the link innerHTML
                link.insertBefore(span, link.firstChild);
            }
        });
    }

    var linkWarning = function(url){
        let desthost = getHostname(url);
        var msg = Joomla.Text._('PLG_SYSTEM_EXTERNALLINKWARNING_WARNING_MESSAGE').replaceAll('{domain}', vars.hostname).replaceAll('{destdomain}', desthost).replaceAll('{sitename}',vars.options.sitename);
        if(confirm(msg)){
            if(vars.options.newtab) {
                window.open(url, '_blank');
                return;
            }
            window.location.href = url;
        }
    }

    construct(options);
}
window.addEventListener('DOMContentLoaded', function() {
    var options = Joomla.getOptions('plg_system_externallinkwarning');
    window.plg_system_externallinkwarning = new plg_system_externallinkwarningClass(options);
});