<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.donottrack
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\DoNotTrack\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\User\User;
use ReflectionClass;
use ReflectionProperty;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
final class DoNotTrack extends CMSPlugin
{
    private $_DNT=0;
    private $_trackingACL=false;
    
    public function onAfterInitialise() {
        
        // we don't run in /administrator
        $this->app = Factory::getApplication();
        if($this->app->isClient('administrator')) return true;

        // we don't run if there's no trackingACL set
        $this->_trackingACL = $this->params->get('trackingACL',false);
        if($this->_trackingACL===false) return true;

        // we don't run if the server doesn't support ReflectionClass or ReflectionProperty
        if(!class_exists('ReflectionClass',false) || !method_exists('ReflectionProperty','setAccessible')) return true;
        
        // JAMSS doesn't like this
        // $this->_DNT = isset($_SERVER['HTTP_DNT'])?$_SERVER['HTTP_DNT']:0;
        $this->_DNT = getenv('HTTP_DNT')?1:0;        

        $user = $this->app->getIdentity();
        $authLevels = $user->getAuthorisedViewLevels();

        if($this->_DNT) {
            // it needs to be a test, because we need the key to not be false
            // this only runs if there's an actual key value
            $key = array_search($this->_trackingACL,$authLevels);
            if($key !== false) { 
                $this->_adjustViewLevel($user,$authLevels,$key);
            }
        } else {
            if(!in_array($this->_trackingACL,$authLevels)) {
                $this->_adjustViewLevel($user,$authLevels);
            }
        }
        return true;
    }

    // Joomla gives no other method to manipulate access levels on-the-fly
    // so we have to use ReflectionClass to do it - you can't stop the signal

    function _adjustViewLevel(&$user,$authLevels,$remove=false) {
        $AuthLevelsReflection = new ReflectionClass('Joomla\CMS\User\User');
        $_authLevels = $AuthLevelsReflection->getProperty('_authLevels');
        $_authLevels->setAccessible(true);  
        if(!$remove) {
            $authLevels[]=$this->_trackingACL;  
        } else {
            unset($authLevels[$remove]);
        }
        $_authLevels->setValue($user,$authLevels);
    }
}