<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.byebyegenerator
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\ByeByeGenerator\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
final class ByeByeGenerator extends CMSPlugin
{
    protected $app;
    protected $doc;
    protected $customGenerator = false;
    
    public function onAfterDispatch()
    {
        // $app = Factory::getApplication();
        if($this->app->isClient('administrator')) {
            return;
        }
        $this->doc = $this->app->getDocument();
        if(!in_array($this->doc->getType(),['html','feed'])) {
            return;
        }
        $custom = trim($this->params->get('custom', ''));
        if(!empty($custom)) {
            $this->doc->setGenerator($custom);
            $this->customGenerator = $custom;
            return;
        }
        $this->doc->setGenerator('');
    }

    public function onAfterRender()
    {
        // $app = Factory::getApplication();
        if($this->app->isClient('administrator')) {
            return;
        }
        if($this->doc->getType() !== 'feed') {
            return;
        }
        if($this->customGenerator) {
            // everything already happened in onAfterDispatch
            return;
        }
        // we're in removal mode now
        $body = $this->app->getBody();
        $find = [
            '/<generator\/>/',
            '/<generator(.*?)><\/generator>/',
            '/<meta name="generator" content="" \/>/',
            '/<meta name="generator" content="Joomla! - Open Source Content Management" \/>/',
            '/<!-- generator="" -->/',
            '/<!-- generator="Joomla! - Open Source Content Management" -->/'
        ];
        $body = preg_replace($find, '', $body);
        $this->app->setBody($body);
    }
}