import { JoomlaEditor } from 'editor-api';
class plg_system_aimeta_class {
    elements = {};
    context = null;
    contexts = {
        'com_content.article': 'jform_articletext',
    }
    constructor() {
        console.log('AI Meta Plugin Loaded');
        this.context = Joomla.getOptions('plg_system_aimeta').context;
        this.setupFields();
    }
    setupFields = function() {
        this.elements.metaDescLabel = document.getElementById('jform_metadesc-lbl');
        this.elements.metaDesc = document.getElementById('jform_metadesc');
        this.decorateLabel(this.elements.metaDescLabel,this.elements.metaDesc);
        
        this.elements.metaKeyLabel = document.getElementById('jform_metakey-lbl');
        this.elements.metaKey = document.getElementById('jform_metakey');
        this.decorateLabel(this.elements.metaKeyLabel,this.elements.metaKey);
    }
    decorateLabel = function(label,input) {
        let buttonGroup = document.createElement('div');
        buttonGroup.className = 'btn-group';
        buttonGroup.setAttribute('role','group');
        let button = document.createElement('button');
        button.type = 'button';
        button.className = 'btn btn-secondary btn-small';
        button.style.marginLeft = '10px';
        button.innerText = Joomla.Text._('PLG_SYSTEM_AIMETA_GENERATE','AI Generate');
        button.addEventListener('click', async () => {
            this.buttonBusy(button, true);
            new Promise(async (resolve, reject) => {
                try {
                    let result = await this.generateMeta(input.id);
                    if(result) {
                        input.value = result;
                        // Dispatch input and change events to satisfy any listeners
                        input.dispatchEvent(new Event('input'));
                        input.dispatchEvent(new Event('change'));
                    }
                    this.buttonBusy(button, false);
                    resolve(result);
                } catch (error) {
                    this.buttonBusy(button, false);
                    Joomla.renderMessages({error: [error.message]});
                    reject(error);
                }
            });
        });
        buttonGroup.appendChild(button);

        let regenerate = document.createElement('button');
        regenerate.type = 'button';
        regenerate.className = 'btn btn-secondary btn-small';
        let icon = document.createElement('span');
        icon.className = 'fa fa-repeat';
        regenerate.appendChild(icon);
        regenerate.style.borderLeft = '1px solid #ccc';
        regenerate.title = 'Regenerate';
        regenerate.addEventListener('click', async () => {
            if(!input.value) {
                return;
            }
            let reason = prompt(Joomla.Text._('PLG_SYSTEM_AIMETA_REGEN_REASON_PROMPT','Please provide a brief reason for regenerating the content (this will be sent to the AI as context).'));
            if(reason === null) {
                // User cancelled
                return;
            }
            this.regenerateButtonBusy(regenerate, true);
            new Promise(async (resolve, reject) => {
                try {
                    let result = await this.generateMeta(input.id, input.value, reason);
                    if(result) {
                        if(input.id === 'jform_metakey') {
                            // if metakey, remove any commas and periods from start or end of string, and double commas
                            result = result.replace(/(^[,.])|([,.]$)/g, '').replace(/,,+/g, ',');
                        }
                        input.value = result;
                        // Dispatch input and change events to satisfy any listeners
                        input.dispatchEvent(new Event('input'));
                        input.dispatchEvent(new Event('change'));
                    }
                    this.regenerateButtonBusy(regenerate, false);
                    resolve(result);
                } catch (error) {
                    this.regenerateButtonBusy(regenerate, false);
                    Joomla.renderMessages({error: [error.message]});
                    reject(error);
                }
            });
        });
        buttonGroup.appendChild(regenerate);

        label.parentElement.classList.add('d-flex','flex-column');
        label.parentElement.appendChild(buttonGroup);
    }

    buttonBusy = function(button, isBusy) {
        if(isBusy) {
            button.disabled = true;
            button.dataset.originalText = button.innerText;
            button.innerText = Joomla.Text._('PLG_SYSTEM_AIMETA_GENERATING','Generating...');
        } else {
            button.disabled = false;
            if(button.dataset.originalText) {
                button.innerText = button.dataset.originalText;
                delete button.dataset.originalText;
            }
        }
    }

    regenerateButtonBusy = function(button, isBusy) {
        if(isBusy) {
            button.disabled = true;
            button.dataset.originalHTML = button.innerHTML;
            button.innerHTML = '<span class="fa fa-spinner fa-spin"></span>';
        } else {
            button.disabled = false;
            if(button.dataset.originalHTML) {
                button.innerHTML = button.dataset.originalHTML;
                delete button.dataset.originalHTML;
            }
        }
    }

    generateMeta = async function(field, current='', reason='') {
        let url = Joomla.getOptions('system.paths').baseFull;
        let query = new URLSearchParams({
            option: 'com_ajax',
            plugin: 'aimeta',
            format: 'json',
            field: field,
            task: 'getResponse'
        });
        let editor = JoomlaEditor.get(this.contexts[this.context]);
        let postData = {
            'title' : document.getElementById('jform_title').value,
            // 'article' : this.htmlToText(document.getElementById('jform_articletext').value),
            'article' : this.htmlToText(editor.getValue()),
            'metakey' : document.getElementById('jform_metakey').value
        }
        if(current) {
            postData.current = current;
        }
        if(reason) {
            postData.reason = reason;
        }
        Joomla.getOptions('plg_system_aimeta').sourceElementIds.forEach(id => {
            let element = document.getElementById(id);
            if(element) {
                postData[id] = element.value;
            }
        });

        let response = await fetch(url + 'index.php?' + query.toString(), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-Token': Joomla.getOptions('csrf.token')
            },
            body: JSON.stringify(postData)
        });
        if(!response.ok) {
            throw new Error('Network response was not ok');
        }
        let data = await response.json();
        if(data.error) {
            throw new Error(data.error);
        }
        return data.data;
    }

    htmlToText = function(html) {
        let doc = new DOMParser().parseFromString(html, 'text/html');
        let text = doc.body.textContent || "";
        // strip carriage returns and new lines, replace with spaces
        text = text.replace(/(\r\n|\n|\r)/gm, " ");
        // replace multiple spaces with a single space
        text = text.replace(/\s+/g, ' ');
        return text.trim();
    }

}

export default plg_system_aimeta_class;