class plg_system_aimeta_class {
    models = {};
    __construct = function() {
        this.setupFields();
    }

    setupFields = function() {
        let metaDesc = document.getElementById('jform_params_metadesc_connection');
        let metaDescModel = document.getElementById('jform_params_metadesc_model');
        metaDesc.addEventListener('change', () => {
            this.loadModels(metaDesc);
        });
        this.loadModels(metaDesc,Joomla.getOptions('plg_system_aimeta').metadesc_model);

        let metaKeys = document.getElementById('jform_params_metakeywords_connection');
        let metaKeysModel = document.getElementById('jform_params_metakeywords_model');
        metaKeys.addEventListener('change', () => {
            this.loadModels(metaKeys);
        });
        this.loadModels(metaKeys,Joomla.getOptions('plg_system_aimeta').metakey_model);
    }

    loadModels = async function(element,selected='') {
        if(!element.value) {
            return;
        }
        // element id contains a name we need to find the connection select
        // id=jform_params_TARGETNAME_connection
        let targetName = element.id.replace('jform_params_','').replace('_connection','');
        let selectID = 'jform_params_' + targetName + '_model';
        let select = document.getElementById(selectID);
        // empty the select
        select.innerHTML = '';
        // find the connection that matches the value of the changed element
        let connection = document.querySelector('input[id^="jform_params__connections__"][id$="__connection"][value="'+element.value+'"]');
        let connectionParent = connection.closest('div.control-group');
        let typeParent = connectionParent.nextElementSibling;
        let type = typeParent.querySelector('select[id^="jform_params__connections__"][id$="__type"]');
        let urlParent = typeParent.nextElementSibling;
        let url = urlParent.querySelector('input[id^="jform_params__connections__"][id$="__url"]');
        let apiKeyParent = urlParent.nextElementSibling;
        let apiKey = apiKeyParent.querySelector('input[id^="jform_params__connections__"][id$="__apikey"]');

        let apiConnection = {
            'connection': connection.value,
            'type': type.value,
            'url': url.value,
            'apikey': apiKey.value
        }
        return new Promise(async (resolve, reject) => {
            try {
            let models = await this.getModels(apiConnection);
            if(models) {
                models[0].forEach(model => {
                let option = new Option(model, model);
                if(model === selected) {
                    option.selected = true;
                }
                select.appendChild(option);
                });
            }
                resolve(models);
            } catch (error) {
                Joomla.renderMessages({error: [Joomla.JText._('PLG_SYSTEM_AIMETA_ERROR_FETCHING_MODELS'), error.message]});
                reject(error);
            }
        });
    }

    getModels = async function(connection) {
        if(this.models[connection.connection]) {
            return this.models[connection.connection];
        }
        let url = Joomla.getOptions('system.paths').baseFull;
        let query = new URLSearchParams({
            'option': 'com_ajax',
            'plugin': 'aimeta',
            'format': 'json',
            'task': 'getModels',
            'connection': connection.connection,
            'url': btoa(connection.url),
            'apikey': btoa(connection.apikey),
            'type': btoa(connection.type)
        });
        let rv = false;
        await fetch(url + '?' + query.toString())
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    rv = data.data;
                } else {
                    console.log(data.message);
                }
            })
            .catch(error => {
                Joomla.renderMessages({error: [Joomla.JText._('PLG_SYSTEM_AIMETA_ERROR_FETCHING_MODELS'), error.message]});
                console.error('Error:', error);
            });
        this.models[connection.connection] = rv;
        return rv;
    }
}

window.addEventListener('DOMContentLoaded', function() {
    this.window.aimetaInstance = new plg_system_aimeta_class();
    aimetaInstance.__construct();
});