class ModernClock{static version="2.0.0";static instances=new Map;static config={defaultRadius:85,renderRadius:100,defaultSkin:"swissRail",smoothSecondHand:true,useRequestAnimationFrame:true};constructor(canvasId,options={}){this.canvasId=canvasId;this.canvas=document.getElementById(canvasId);if(!this.canvas){throw new Error(`Canvas element with id "${canvasId}" not found`)}this.options={displayRadius:options.displayRadius||ModernClock.config.defaultRadius,skin:options.skin||ModernClock.config.defaultSkin,showSecondHand:options.showSecondHand!==false,showDate:options.showDate||false,showAMPM:options.showAMPM||false,gmtOffset:options.gmtOffset!==undefined?parseFloat(options.gmtOffset):null,smoothSecondHand:options.smoothSecondHand!==false,onTick:options.onTick||null,customSkin:options.customSkin||null,responsive:options.responsive!==false,useNTP:options.useNTP||false,useDateHeader:options.useDateHeader||null,logo:options.logo||null};this.renderRadius=ModernClock.config.renderRadius;this.scale=this.options.displayRadius/this.renderRadius;this.animationFrameId=null;this.lastRenderTime=0;this.isVisible=true;this.timeOffset=0;this.resizeObserver=null;this.logoImage=null;this.logoReady=false;this.init();this.observe(this.canvas);ModernClock.instances.set(canvasId,this)}observe(element){const observer=new IntersectionObserver(entries=>{entries.forEach(entry=>{if(entry.isIntersecting){this.isVisible=true;this.start()}else{this.isVisible=false;this.stop()}})});observer.observe(element)}init(){if(this.options.responsive){this.canvas.style.aspectRatio="1";this.canvas.style.width="100%";this.canvas.style.height="auto";this.canvas.style.maxWidth="100%";this.canvas.style.display="block"}this.updateCanvasSize();this.ctx=this.canvas.getContext("2d");if(this.options.responsive&&typeof ResizeObserver!=="undefined"){this.resizeObserver=new ResizeObserver(()=>{this.updateCanvasSize()});this.resizeObserver.observe(this.canvas.parentElement||this.canvas)}if(this.options.useNTP){this.syncNTPTime()}else if(this.options.useDateHeader){this.syncDateHeader()}if(this.options.logo){this.loadLogo()}this.start()}reloadClock(){this.stop();this.init()}updateOption(key,value){switch(key){case"skin":this.options.skin=value;this.options.customSkin=null;break;case"customSkin":this.options.customSkin=value;break;default:this.options[key]=value}}updateCanvasSize(){let size;if(this.options.responsive){const container=this.canvas.parentElement;if(container){const rect=container.getBoundingClientRect();size=Math.min(rect.width,rect.height)}else{size=this.canvas.offsetWidth||this.options.displayRadius*2}}else{size=this.options.displayRadius*2}const dpr=window.devicePixelRatio||1;this.canvas.width=size*dpr;this.canvas.height=size*dpr;this.scale=size*dpr/2/this.renderRadius;if(this.ctx){this.ctx.setTransform(1,0,0,1,0,0);this.ctx.scale(this.scale,this.scale)}}start(){if(this.animationFrameId)return;this.tick()}stop(){if(this.animationFrameId){cancelAnimationFrame(this.animationFrameId);this.animationFrameId=null}}destroy(){this.stop();if(this.resizeObserver){this.resizeObserver.disconnect();this.resizeObserver=null}ModernClock.instances.delete(this.canvasId)}async syncNTPTime(){const cachedOffset=this.getNTPCookie();if(cachedOffset!==null){this.timeOffset=cachedOffset;if(this.options.onNTPSync){this.options.onNTPSync(this.timeOffset,true)}return}const endpoints=[{url:"https://timeapi.io/api/Time/current/zone?timeZone=UTC",parser:data=>new Date(data.dateTime)},{url:"https://worldtimeapi.org/api/timezone/Etc/UTC",parser:data=>new Date(data.datetime||data.utc_datetime)},{url:"http://worldtimeapi.org/api/timezone/Etc/UTC",parser:data=>new Date(data.datetime||data.utc_datetime)}];const maxRetries=2;let lastError=null;for(const endpoint of endpoints){for(let attempt=0;attempt<=maxRetries;attempt++){try{const response=await fetch(endpoint.url,{cache:"no-store",mode:"cors",signal:AbortSignal.timeout(5e3)});if(!response.ok){throw new Error(`HTTP ${response.status}: ${response.statusText}`)}const data=await response.json();const serverTime=endpoint.parser(data);const localTime=new Date;this.timeOffset=serverTime.getTime()-localTime.getTime();this.setNTPCookie(this.timeOffset);if(this.options.onNTPSync){this.options.onNTPSync(this.timeOffset,false)}return}catch(error){lastError=error;if(attempt<maxRetries){await new Promise(resolve=>setTimeout(resolve,500*(attempt+1)));continue}console.warn(`ModernClock: Failed to sync with ${endpoint.url} after ${maxRetries+1} attempts`)}}}console.warn("ModernClock: All NTP sync attempts failed, using local time",lastError);this.timeOffset=0;if(this.options.onNTPError){this.options.onNTPError(lastError||new Error("All time sync endpoints failed"))}}getNTPCookie(){const name="modernclock_ntp_offset=";const cookieStart=document.cookie.indexOf(name);if(cookieStart!==-1){return parseFloat(document.cookie.substring(cookieStart+name.length).split(";")[0])}return null}setNTPCookie(offset){const expires=new Date;expires.setTime(expires.getTime()+24*60*60*1e3);document.cookie=`modernclock_ntp_offset=${offset};expires=${expires.toUTCString()};path=/;SameSite=Lax`}clearNTPCookie(){document.cookie="modernclock_ntp_offset=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;"}async syncDateHeader(){const cachedOffset=this.getNTPCookie();if(cachedOffset!==null){this.timeOffset=cachedOffset;if(this.options.onNTPSync){this.options.onNTPSync(this.timeOffset,true)}return}const url=this.options.useDateHeader;if(!url)return;try{const response=await fetch(url,{method:"HEAD",cache:"no-store"});const dateHeader=response.headers.get("Date");if(!dateHeader){throw new Error("No Date header in response")}const serverTime=new Date(dateHeader);const localTime=new Date;if(isNaN(serverTime.getTime())){throw new Error("Invalid Date header: "+dateHeader)}this.timeOffset=serverTime.getTime()-localTime.getTime();this.setNTPCookie(this.timeOffset);if(this.options.onNTPSync){this.options.onNTPSync(this.timeOffset,false)}}catch(error){this.timeOffset=0;if(this.options.onNTPError){this.options.onNTPError(error)}}}tick(timestamp=0){if(!this.isVisible)return;if(!document.body.contains(this.canvas)){this.destroy();return}if(this.canvas.offsetParent===null){this.animationFrameId=requestAnimationFrame(ts=>this.tick(ts));return}const now=new Date(Date.now()+this.timeOffset);let hours,minutes,seconds,milliseconds;if(this.options.gmtOffset!==null){const offsetMs=this.options.gmtOffset*36e5;const offsetDate=new Date(now.getTime()+offsetMs);hours=offsetDate.getUTCHours();minutes=offsetDate.getUTCMinutes();seconds=offsetDate.getUTCSeconds();milliseconds=offsetDate.getUTCMilliseconds()}else{hours=now.getHours();minutes=now.getMinutes();seconds=now.getSeconds();milliseconds=now.getMilliseconds()}if(this.options.smoothSecondHand){seconds+=milliseconds/1e3}this.render(hours,minutes,seconds);if(this.options.onTick){this.options.onTick(hours,minutes,seconds)}this.animationFrameId=requestAnimationFrame(ts=>this.tick(ts))}render(hours,minutes,seconds){const skin=this.getSkin();this.ctx.clearRect(0,0,this.renderRadius*2,this.renderRadius*2);if(skin.outerBorder)this.drawCircle(skin.outerBorder);if(skin.face)this.drawCircle(skin.face);this.drawIndicators(skin);if(this.options.logo&&this.logoReady){this.drawLogo()}if(this.options.showAMPM){this.drawAMPM(hours,skin)}if(skin.hourHand)this.drawHand((hours%12+minutes/60)/12,skin.hourHand);if(skin.minuteHand)this.drawHand((minutes+seconds/60)/60,skin.minuteHand);if(this.options.showSecondHand&&skin.secondHand){this.drawHand(seconds/60,skin.secondHand);if(skin.secondDecoration){this.drawHandDecoration(seconds/60,skin.secondDecoration)}}if(skin.centerDot)this.drawCircle(skin.centerDot)}getSkin(){if(this.options.customSkin){return this.options.customSkin}const skinName=this.options.skin;if(!ModernClock.skins[skinName]){console.warn(`Skin "${skinName}" not found, using default`);return ModernClock.skins[ModernClock.config.defaultSkin]}return ModernClock.skins[skinName]}drawCircle(style){this.ctx.save();this.ctx.globalAlpha=style.alpha??1;this.ctx.lineWidth=style.lineWidth??1;this.ctx.beginPath();this.ctx.arc(this.renderRadius,this.renderRadius,style.radius,0,2*Math.PI);if(style.fillColor){this.ctx.fillStyle=style.fillColor;this.ctx.fill()}if(style.color&&style.lineWidth){this.ctx.strokeStyle=style.color;this.ctx.stroke()}this.ctx.restore()}drawIndicators(skin){for(let i=0;i<60;i++){const isLarge=i%5===0;const indicator=isLarge?skin.largeIndicator:skin.smallIndicator;if(indicator){this.drawRadialLine(i/60,indicator)}}}drawHand(angleFraction,style){this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.rotate(Math.PI*(2*angleFraction-.5));this.ctx.globalAlpha=style.alpha??1;this.ctx.strokeStyle=style.color;this.ctx.lineWidth=style.lineWidth;this.ctx.lineCap=style.lineCap||"round";this.ctx.beginPath();this.ctx.moveTo(style.startAt||0,0);this.ctx.lineTo(style.endAt,0);this.ctx.stroke();this.ctx.restore()}drawHandDecoration(angleFraction,style){this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.rotate(Math.PI*(2*angleFraction-.5));this.ctx.globalAlpha=style.alpha??1;this.ctx.lineWidth=style.lineWidth??1;if(style.radius){this.ctx.beginPath();this.ctx.arc(style.startAt||0,0,style.radius,0,2*Math.PI);if(style.fillColor){this.ctx.fillStyle=style.fillColor;this.ctx.fill()}if(style.color){this.ctx.strokeStyle=style.color;this.ctx.stroke()}}this.ctx.restore()}drawRadialLine(angleFraction,style){this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.rotate(Math.PI*(2*angleFraction-.5));this.ctx.globalAlpha=style.alpha??1;this.ctx.strokeStyle=style.color;this.ctx.lineWidth=style.lineWidth;this.ctx.lineCap=style.lineCap||"butt";if(style.radius){this.ctx.beginPath();this.ctx.arc(style.startAt,0,style.radius,0,2*Math.PI);if(style.fillColor){this.ctx.fillStyle=style.fillColor;this.ctx.fill()}this.ctx.stroke()}else{this.ctx.beginPath();this.ctx.moveTo(style.startAt,0);this.ctx.lineTo(style.endAt,0);this.ctx.stroke()}this.ctx.restore()}drawAMPM(hours,skin){const isPM=hours>=12;const text=isPM?"PM":"AM";const textStyle=skin.ampmText||{color:skin.hourHand?.color||"black",alpha:.8,fontSize:10,fontFamily:"Arial, sans-serif",fontWeight:"bold"};this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.globalAlpha=textStyle.alpha;this.ctx.fillStyle=textStyle.color;this.ctx.font=`${textStyle.fontWeight} ${textStyle.fontSize}px ${textStyle.fontFamily}`;this.ctx.textAlign="center";this.ctx.textBaseline="middle";const yPosition=40;this.ctx.fillText(text,0,yPosition);this.ctx.restore()}async loadLogo(){if(!this.options.logo)return;const logo=this.options.logo;if(logo.text){this.logoReady=true;return}if(logo.svg){try{let svgString=logo.svg.trim();if(!svgString.includes("xmlns")){svgString=svgString.replace("<svg",'<svg xmlns="http://www.w3.org/2000/svg"')}const base64=btoa(unescape(encodeURIComponent(svgString)));const dataUrl=`data:image/svg+xml;base64,${base64}`;this.logoImage=new Image;this.logoImage.onload=()=>{this.logoReady=true};this.logoImage.onerror=e=>{console.warn("ModernClock: SVG logo failed to load",e);console.warn("SVG content:",svgString)};this.logoImage.src=dataUrl}catch(error){console.warn("ModernClock: Error loading SVG logo",error)}return}if(logo.src){this.logoImage=new Image;this.logoImage.onload=()=>{this.logoReady=true};this.logoImage.onerror=e=>{console.warn("ModernClock: Logo image failed to load from:",logo.src,e)};if(logo.src.startsWith("http")&&!logo.src.startsWith(window.location.origin)&&!logo.src.startsWith("data:")){this.logoImage.crossOrigin="anonymous"}this.logoImage.src=logo.src}}drawLogo(){if(!this.logoReady||!this.options.logo)return;const logo=this.options.logo;const skin=this.getSkin();this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.globalAlpha=logo.alpha??1;if(logo.text){const textStyle=logo.style||{color:logo.color||skin.hourHand?.color||"black",fontSize:logo.fontSize||14,fontFamily:logo.fontFamily||"Arial, sans-serif",fontWeight:logo.fontWeight||"bold"};this.ctx.fillStyle=textStyle.color;this.ctx.font=`${textStyle.fontWeight} ${textStyle.fontSize}px ${textStyle.fontFamily}`;this.ctx.textAlign="center";this.ctx.textBaseline="middle";const yPosition=logo.position?.y??-40;this.ctx.fillText(logo.text,logo.position?.x??0,yPosition)}else if(this.logoImage){const w=logo.width||30;const h=logo.height||30;const x=logo.position?.x??0;const y=logo.position?.y??-40;this.ctx.drawImage(this.logoImage,x-w/2,y-h/2,w,h)}this.ctx.restore()}updateOptions(newOptions){const oldResponsive=this.options.responsive;const oldUseNTP=this.options.useNTP;const oldLogo=this.options.logo;Object.assign(this.options,newOptions);if(newOptions.logo!==undefined&&newOptions.logo!==oldLogo){this.logoReady=false;this.logoImage=null;if(newOptions.logo){this.loadLogo()}}if(newOptions.displayRadius||newOptions.responsive!==undefined){if(newOptions.responsive!==undefined&&newOptions.responsive!==oldResponsive){if(newOptions.responsive){this.canvas.style.aspectRatio="1";this.canvas.style.width="100%";this.canvas.style.height="auto";this.canvas.style.maxWidth="100%";this.canvas.style.display="block";if(typeof ResizeObserver!=="undefined"&&!this.resizeObserver){this.resizeObserver=new ResizeObserver(()=>{this.updateCanvasSize()});this.resizeObserver.observe(this.canvas.parentElement||this.canvas)}}else{if(this.resizeObserver){this.resizeObserver.disconnect();this.resizeObserver=null}this.canvas.style.aspectRatio="";this.canvas.style.width="";this.canvas.style.height=""}}this.updateCanvasSize()}if(newOptions.useNTP!==undefined&&newOptions.useNTP&&!oldUseNTP){this.syncNTPTime()}if(newOptions.useDateHeader!==undefined&&newOptions.useDateHeader&&!this.options.useDateHeader){this.syncDateHeader()}}static autoInit(selector="canvas[data-clock]"){const canvases=document.querySelectorAll(selector);canvases.forEach(canvas=>{if(ModernClock.instances.has(canvas.id))return;const dataset=canvas.dataset;const options={displayRadius:dataset.radius?parseInt(dataset.radius):undefined,skin:dataset.skin||undefined,showSecondHand:dataset.showSeconds!=="false",showAMPM:dataset.showAmpm==="true",gmtOffset:dataset.gmtOffset?parseFloat(dataset.gmtOffset):undefined,smoothSecondHand:dataset.smoothSeconds!=="false",responsive:dataset.responsive!=="false",useNTP:dataset.useNtp==="true"};new ModernClock(canvas.id,options)})}static getInstance(canvasId){return ModernClock.instances.get(canvasId)}static destroyAll(){ModernClock.instances.forEach(instance=>instance.destroy());ModernClock.instances.clear()}static forceNTPSync(){document.cookie="modernclock_ntp_offset=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;";ModernClock.instances.forEach(instance=>{if(instance.options.useNTP){instance.timeOffset=0;instance.syncNTPTime()}})}}if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",()=>{if(document.querySelector("[data-clock-auto-init]")){ModernClock.autoInit()}const scriptOptions=Joomla.getOptions("mod_coolclock");if(scriptOptions){Object.keys(scriptOptions).forEach(modId=>{const options=scriptOptions[modId];const canvas=document.getElementById(modId+"_canvas");if(canvas){new ModernClock(canvas.id,options)}})}})}else{if(document.querySelector("[data-clock-auto-init]")){ModernClock.autoInit()}const scriptOptions=Joomla.getOptions("mod_coolclock");if(scriptOptions){Object.keys(scriptOptions).forEach(modId=>{const options=scriptOptions[modId];const canvas=document.getElementById(modId+"_canvas");if(canvas){new ModernClock(canvas.id,options)}})}}if(typeof module!=="undefined"&&module.exports){module.exports=ModernClock}ModernClock.skins={swissRail:{outerBorder:{lineWidth:1,radius:95,color:"black",alpha:1},smallIndicator:{lineWidth:2,startAt:89,endAt:93,color:"black",alpha:1},largeIndicator:{lineWidth:4,startAt:80,endAt:93,color:"black",alpha:1},hourHand:{lineWidth:8,startAt:-15,endAt:50,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:7,startAt:-15,endAt:75,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:-20,endAt:85,color:"red",alpha:1},secondDecoration:{lineWidth:1,startAt:70,radius:4,fillColor:"red",color:"red",alpha:1}},chunkySwiss:{outerBorder:{lineWidth:4,radius:97,color:"black",alpha:1},smallIndicator:{lineWidth:4,startAt:89,endAt:93,color:"black",alpha:1},largeIndicator:{lineWidth:8,startAt:80,endAt:93,color:"black",alpha:1},hourHand:{lineWidth:12,startAt:-15,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:10,startAt:-15,endAt:85,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:4,startAt:-20,endAt:85,color:"red",alpha:1},secondDecoration:{lineWidth:2,startAt:70,radius:8,fillColor:"red",color:"red",alpha:1}},chunkySwissOnBlack:{face:{radius:100,fillColor:"#000000",alpha:1},outerBorder:{lineWidth:4,radius:97,color:"white",alpha:1},smallIndicator:{lineWidth:4,startAt:89,endAt:93,color:"white",alpha:1},largeIndicator:{lineWidth:8,startAt:80,endAt:93,color:"white",alpha:1},hourHand:{lineWidth:12,startAt:-15,endAt:60,color:"white",alpha:1,lineCap:"round"},minuteHand:{lineWidth:10,startAt:-15,endAt:85,color:"white",alpha:1,lineCap:"round"},secondHand:{lineWidth:4,startAt:-20,endAt:85,color:"red",alpha:1},secondDecoration:{lineWidth:2,startAt:70,radius:8,fillColor:"red",color:"red",alpha:1}},fancy:{outerBorder:{lineWidth:5,radius:95,color:"green",alpha:.7},smallIndicator:{lineWidth:1,startAt:80,endAt:93,color:"black",alpha:.4},largeIndicator:{lineWidth:1,startAt:30,endAt:93,color:"black",alpha:.5},hourHand:{lineWidth:8,startAt:-15,endAt:50,color:"blue",alpha:.7,lineCap:"round"},minuteHand:{lineWidth:7,startAt:-15,endAt:92,color:"red",alpha:.7,lineCap:"round"},secondHand:{lineWidth:10,startAt:80,endAt:85,color:"blue",alpha:.3},secondDecoration:{lineWidth:1,startAt:30,radius:50,fillColor:"blue",color:"red",alpha:.15}},machine:{outerBorder:{lineWidth:60,radius:55,color:"#dd6655",alpha:1},smallIndicator:{lineWidth:4,startAt:80,endAt:95,color:"white",alpha:1},largeIndicator:{lineWidth:14,startAt:77,endAt:92,color:"#dd6655",alpha:1},hourHand:{lineWidth:18,startAt:-15,endAt:40,color:"white",alpha:1,lineCap:"round"},minuteHand:{lineWidth:14,startAt:24,endAt:100,color:"#771100",alpha:.5,lineCap:"round"},secondHand:{lineWidth:3,startAt:22,endAt:83,color:"green",alpha:0},secondDecoration:{lineWidth:1,startAt:52,radius:26,fillColor:"#ffcccc",color:"red",alpha:.5}},classic:{face:{radius:100,fillColor:"#E5ECF9",alpha:1},outerBorder:{lineWidth:2,radius:98,color:"#3366CC",alpha:1},smallIndicator:{lineWidth:2,startAt:89,endAt:94,color:"#3366CC",alpha:1},largeIndicator:{lineWidth:4,startAt:83,endAt:94,color:"#3366CC",alpha:1},hourHand:{lineWidth:5,startAt:0,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:4,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:-20,endAt:85,color:"red",alpha:.85},secondDecoration:{lineWidth:3,startAt:0,radius:2,fillColor:"black",color:"black",alpha:1}},modern:{face:{radius:100,fillColor:"#E5ECF9",alpha:1},outerBorder:{lineWidth:2,radius:98,color:"#3366CC",alpha:1},smallIndicator:{lineWidth:5,startAt:88,endAt:94,color:"#3366CC",alpha:1},largeIndicator:{lineWidth:5,startAt:88,endAt:94,color:"#3366CC",alpha:1},hourHand:{lineWidth:8,startAt:0,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:8,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:5,startAt:80,endAt:85,color:"red",alpha:.85},secondDecoration:{lineWidth:3,startAt:0,radius:4,fillColor:"black",color:"black",alpha:1}},simple:{face:{radius:100,fillColor:"#E5ECF9",alpha:1},outerBorder:{lineWidth:2,radius:98,color:"#3366CC",alpha:1},smallIndicator:{lineWidth:10,startAt:90,endAt:94,color:"#3366CC",alpha:1},largeIndicator:{lineWidth:10,startAt:90,endAt:94,color:"#3366CC",alpha:1},hourHand:{lineWidth:8,startAt:0,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:8,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:5,startAt:80,endAt:85,color:"red",alpha:.85},secondDecoration:{lineWidth:3,startAt:0,radius:4,fillColor:"black",color:"black",alpha:1}},securephp:{outerBorder:{lineWidth:100,radius:.45,color:"#669900",alpha:.3},smallIndicator:{lineWidth:2,startAt:80,endAt:90,color:"green",alpha:1},largeIndicator:{lineWidth:8.5,startAt:20,endAt:40,color:"green",alpha:.4},hourHand:{lineWidth:3,startAt:0,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:2,startAt:0,endAt:75,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:-10,endAt:80,color:"blue",alpha:.8},secondDecoration:{lineWidth:1,startAt:70,radius:4,fillColor:"blue",color:"red",alpha:1}},Tes2:{outerBorder:{lineWidth:4,radius:95,color:"black",alpha:.5},smallIndicator:{lineWidth:1,startAt:10,endAt:50,color:"#66CCFF",alpha:1},largeIndicator:{lineWidth:8.5,startAt:60,endAt:70,color:"#6699FF",alpha:1},hourHand:{lineWidth:5,startAt:-15,endAt:60,color:"black",alpha:.7,lineCap:"round"},minuteHand:{lineWidth:3,startAt:-25,endAt:75,color:"black",alpha:.7,lineCap:"round"},secondHand:{lineWidth:1.5,startAt:-20,endAt:88,color:"red",alpha:1},secondDecoration:{lineWidth:1,startAt:20,radius:4,fillColor:"blue",color:"red",alpha:1}},Lev:{outerBorder:{lineWidth:10,radius:95,color:"#CCFF33",alpha:.65},smallIndicator:{lineWidth:5,startAt:84,endAt:90,color:"#996600",alpha:1},largeIndicator:{lineWidth:40,startAt:25,endAt:95,color:"#336600",alpha:.55},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:.9,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:.85,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:85,color:"black",alpha:1},secondDecoration:{lineWidth:2,startAt:5,radius:10,fillColor:"black",color:"black",alpha:1}},Sand:{outerBorder:{lineWidth:1,radius:70,color:"black",alpha:.5},smallIndicator:{lineWidth:3,startAt:50,endAt:70,color:"#0066FF",alpha:.5},largeIndicator:{lineWidth:200,startAt:80,endAt:95,color:"#996600",alpha:.75},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:.9,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:.85,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:85,color:"black",alpha:1},secondDecoration:{lineWidth:2,startAt:5,radius:10,fillColor:"black",color:"black",alpha:1}},Sun:{outerBorder:{lineWidth:100,radius:140,color:"#99FFFF",alpha:.2},smallIndicator:{lineWidth:300,startAt:50,endAt:70,color:"black",alpha:.1},largeIndicator:{lineWidth:5,startAt:80,endAt:95,color:"black",alpha:.65},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:.9,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:.85,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:90,color:"black",alpha:1},secondDecoration:{lineWidth:2,startAt:5,radius:10,fillColor:"black",color:"black",alpha:1}},Tor:{outerBorder:{lineWidth:10,radius:88,color:"#996600",alpha:.9},smallIndicator:{lineWidth:6,startAt:-10,endAt:73,color:"green",alpha:.3},largeIndicator:{lineWidth:6,startAt:73,endAt:100,color:"black",alpha:.65},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:-73,endAt:73,color:"black",alpha:.8},secondDecoration:{lineWidth:2,startAt:5,radius:10,fillColor:"black",color:"black",alpha:1}},Cold:{outerBorder:{lineWidth:15,radius:90,color:"black",alpha:.3},smallIndicator:{lineWidth:15,startAt:-10,endAt:95,color:"blue",alpha:.1},largeIndicator:{lineWidth:3,startAt:80,endAt:95,color:"blue",alpha:.65},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:85,color:"black",alpha:.8},secondDecoration:{lineWidth:5,startAt:30,radius:10,fillColor:"black",color:"black",alpha:1}},Babosa:{outerBorder:{lineWidth:100,radius:25,color:"blue",alpha:.25},smallIndicator:{lineWidth:3,startAt:90,endAt:95,color:"#3366CC",alpha:1},largeIndicator:{lineWidth:4,startAt:75,endAt:95,color:"#3366CC",alpha:1},hourHand:{lineWidth:4,startAt:0,endAt:60,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:85,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:12,startAt:75,endAt:90,color:"red",alpha:.8},secondDecoration:{lineWidth:3,startAt:0,radius:4,fillColor:"black",color:"black",alpha:1}},Tumb:{outerBorder:{lineWidth:105,radius:5,color:"green",alpha:.4},smallIndicator:{lineWidth:1,startAt:93,endAt:98,color:"green",alpha:1},largeIndicator:{lineWidth:50,startAt:0,endAt:89,color:"red",alpha:.14},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:80,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:85,color:"black",alpha:.8},secondDecoration:{lineWidth:5,startAt:50,radius:90,fillColor:"black",color:"black",alpha:.05}},Stone:{outerBorder:{lineWidth:15,radius:80,color:"#339933",alpha:.5},smallIndicator:{lineWidth:2,startAt:70,endAt:90,color:"#FF3300",alpha:.7},largeIndicator:{lineWidth:15,startAt:0,endAt:29,color:"#FF6600",alpha:.3},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:75,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:0,endAt:85,color:"black",alpha:.8},secondDecoration:{lineWidth:5,startAt:50,radius:90,fillColor:"black",color:"black",alpha:.05}},Disc:{outerBorder:{lineWidth:105,radius:1,color:"#666600",alpha:.2},smallIndicator:{lineWidth:1,startAt:58,endAt:95,color:"#669900",alpha:.8},largeIndicator:{lineWidth:6,startAt:25,endAt:35,color:"#666600",alpha:1},hourHand:{lineWidth:4,startAt:0,endAt:65,color:"black",alpha:1,lineCap:"round"},minuteHand:{lineWidth:3,startAt:0,endAt:75,color:"black",alpha:1,lineCap:"round"},secondHand:{lineWidth:1,startAt:-75,endAt:75,color:"#99CC00",alpha:.8},secondDecoration:{lineWidth:5,startAt:50,radius:90,fillColor:"#00FF00",color:"green",alpha:.05}},minimal:{face:{radius:100,fillColor:"#ffffff",alpha:1},outerBorder:{lineWidth:1,radius:99,color:"#e0e0e0",alpha:1},smallIndicator:{lineWidth:1,startAt:92,endAt:96,color:"#cccccc",alpha:1},largeIndicator:{lineWidth:2,startAt:88,endAt:96,color:"#666666",alpha:1},hourHand:{lineWidth:6,startAt:-10,endAt:50,color:"#333333",alpha:1,lineCap:"round"},minuteHand:{lineWidth:4,startAt:-10,endAt:70,color:"#333333",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-15,endAt:80,color:"#ff4444",alpha:1},centerDot:{radius:3,fillColor:"#333333",alpha:1}},dark:{face:{radius:100,fillColor:"#1a1a1a",alpha:1},outerBorder:{lineWidth:2,radius:98,color:"#333333",alpha:1},smallIndicator:{lineWidth:2,startAt:90,endAt:95,color:"#666666",alpha:1},largeIndicator:{lineWidth:3,startAt:85,endAt:95,color:"#888888",alpha:1},hourHand:{lineWidth:7,startAt:-12,endAt:55,color:"#ffffff",alpha:1,lineCap:"round"},minuteHand:{lineWidth:5,startAt:-12,endAt:75,color:"#ffffff",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-18,endAt:85,color:"#00d4ff",alpha:1},centerDot:{radius:4,fillColor:"#00d4ff",alpha:1}},neon:{face:{radius:100,fillColor:"#0a0a0a",alpha:1},outerBorder:{lineWidth:3,radius:97,color:"#ff00ff",alpha:.8},smallIndicator:{lineWidth:2,startAt:90,endAt:94,color:"#00ffff",alpha:.6},largeIndicator:{lineWidth:4,startAt:85,endAt:94,color:"#ff00ff",alpha:.8},hourHand:{lineWidth:8,startAt:-10,endAt:50,color:"#ff00ff",alpha:.9,lineCap:"round"},minuteHand:{lineWidth:6,startAt:-10,endAt:70,color:"#00ffff",alpha:.9,lineCap:"round"},secondHand:{lineWidth:2,startAt:-20,endAt:85,color:"#ffff00",alpha:1},centerDot:{radius:4,fillColor:"#ffffff",alpha:1}},ocean:{face:{radius:100,fillColor:"#e6f3ff",alpha:1},outerBorder:{lineWidth:4,radius:96,color:"#0066cc",alpha:.8},smallIndicator:{lineWidth:2,startAt:90,endAt:94,color:"#0099cc",alpha:.7},largeIndicator:{lineWidth:5,startAt:82,endAt:94,color:"#0066cc",alpha:.9},hourHand:{lineWidth:9,startAt:-12,endAt:55,color:"#003d7a",alpha:1,lineCap:"round"},minuteHand:{lineWidth:6,startAt:-12,endAt:75,color:"#004d99",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-20,endAt:85,color:"#00ccff",alpha:1},secondDecoration:{lineWidth:1,startAt:70,radius:5,fillColor:"#00ccff",color:"#00ccff",alpha:1}},sunset:{face:{radius:100,fillColor:"#fff4e6",alpha:1},outerBorder:{lineWidth:5,radius:95,color:"#ff6b35",alpha:.9},smallIndicator:{lineWidth:2,startAt:88,endAt:93,color:"#ff8c42",alpha:.8},largeIndicator:{lineWidth:5,startAt:80,endAt:93,color:"#ff6b35",alpha:1},hourHand:{lineWidth:9,startAt:-15,endAt:50,color:"#d84315",alpha:1,lineCap:"round"},minuteHand:{lineWidth:7,startAt:-15,endAt:70,color:"#f4511e",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-20,endAt:85,color:"#ffc107",alpha:1},centerDot:{radius:4,fillColor:"#ffc107",alpha:1}},forest:{face:{radius:100,fillColor:"#f1f8f4",alpha:1},outerBorder:{lineWidth:4,radius:96,color:"#2d5016",alpha:1},smallIndicator:{lineWidth:2,startAt:88,endAt:93,color:"#558b2f",alpha:.8},largeIndicator:{lineWidth:5,startAt:78,endAt:93,color:"#2d5016",alpha:1},hourHand:{lineWidth:9,startAt:-12,endAt:55,color:"#1b3409",alpha:1,lineCap:"round"},minuteHand:{lineWidth:7,startAt:-12,endAt:75,color:"#2d5016",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-18,endAt:85,color:"#8bc34a",alpha:1},secondDecoration:{lineWidth:1,startAt:70,radius:5,fillColor:"#8bc34a",color:"#8bc34a",alpha:1}},luxury:{face:{radius:100,fillColor:"#1a1a1a",alpha:1},outerBorder:{lineWidth:8,radius:92,color:"#d4af37",alpha:1},smallIndicator:{lineWidth:1,startAt:88,endAt:90,color:"#d4af37",alpha:.6},largeIndicator:{lineWidth:4,startAt:75,endAt:90,color:"#d4af37",alpha:1},hourHand:{lineWidth:10,startAt:-8,endAt:50,color:"#d4af37",alpha:1,lineCap:"round"},minuteHand:{lineWidth:7,startAt:-8,endAt:70,color:"#d4af37",alpha:1,lineCap:"round"},secondHand:{lineWidth:2,startAt:-15,endAt:82,color:"#ffd700",alpha:1},centerDot:{radius:5,fillColor:"#d4af37",alpha:1}},retro:{face:{radius:100,fillColor:"#fef5e7",alpha:1},outerBorder:{lineWidth:6,radius:94,color:"#d35400",alpha:1},smallIndicator:{lineWidth:3,startAt:88,endAt:92,color:"#e67e22",alpha:1},largeIndicator:{lineWidth:6,startAt:80,endAt:92,color:"#d35400",alpha:1},hourHand:{lineWidth:10,startAt:-10,endAt:50,color:"#a04000",alpha:1,lineCap:"round"},minuteHand:{lineWidth:8,startAt:-10,endAt:70,color:"#c0562f",alpha:1,lineCap:"round"},secondHand:{lineWidth:3,startAt:-20,endAt:85,color:"#e74c3c",alpha:1},secondDecoration:{lineWidth:2,startAt:70,radius:6,fillColor:"#e74c3c",color:"#e74c3c",alpha:1}}};
