<?php
/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Fields\XMLForm\Extension;

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

class XMLFormHelper {
	static function tableHeadings($formsource) {
		$xml = new \SimpleXMLElement(file_get_contents(JPATH_ROOT.'/'.$formsource));
		$fields = array();
		foreach($xml->xpath('//field') as $field) {
			$name = (string)$field->attributes()->name;
			$fields[$name] = array();
			$fields[$name]['label'] = Text::_((string)$field->attributes()->label);
			switch((string)$field->attributes()->type) {
				case 'radio':
				case 'checkboxes':
				case 'list':
					$fields[$name]['options'] = array();
					foreach($field->children() as $option) {
						$fields[$name]['options'][(string)$option->attributes()->value] = Text::_((string)$option);
					}
					break;
				default:
					break;
			}
		}
		return $fields;
	}
	
	static function table($headings,$rows) {
		$r = array('<table class="table">');
		$r[] = '<tr>';
		foreach($headings as $heading) {
			$r[] = '<th>'.$heading['label'].'</th>';
		}
		$r[] = '</tr>';
		if(count($rows,0) === count($rows,1)) {
                        $r[] = '<tr><td>'.implode('</td><td>',$rows).'</td></tr>';
                } else {
			foreach($rows as $row) {
				$r[] = '<tr>';
				foreach($row as $key=>$value) {
					$r[] = '<td>';
					$r[] = array_key_exists('options',$headings[$key])?$headings[$key]['options'][$value]:$value;
					$r[] = '</td>';
				}
				$r[] = '</tr>';
			}
		}
		$r[] = '</table>';
		return implode("\n",$r);
	}
}