<?php
/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\Fields\XMLForm\Extension;

use Joomla\CMS\Form\Form;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Component\Fields\Administrator\Plugin\FieldsPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\CustomFields\PrepareDomEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;


// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

final class XMLForm extends FieldsPlugin /* implements SubscriberInterface */
{
    // use UserFactoryAwareTrait;

    /**
     * Returns the events that the plugin will listen to.
     *
     * @return  array  The events to listen to.
     *
     * @since   4.0.0
     */
    // public static function getSubscribedEvents(): array
    // {
        // return [
        //     'onCustomFieldsPrepareDom' => 'onCustomFieldsPrepareDom',
        //     'onCustomFieldsBeforePrepareField' => 'onCustomFieldsBeforePrepareField',
        // ];
    // }
	/**
	 * Transforms the field into a DOM XML element and appends it as a child on the given parent.
	 *
	 * @param   stdClass    $field   The field.
	 * @param   DOMElement  $parent  The field node parent.
	 * @param   Form       $form    The form.
	 *
	 * @return  DOMElement
	 *
	 * @since   3.7.0
	 */
    public function onCustomFieldsPrepareDom($field, \DOMElement $parent, Form $form)
    // public function onCustomFieldsPrepareDom(PrepareDomEvent $event)
    {
        // $field  = $event->getField();
        // $parent = $event->getFieldset();
        // $form   = $event->getForm();

		// $fieldNode = parent::onCustomFieldsPrepareDom($event);
		$fieldNode = parent::onCustomFieldsPrepareDom($field, $parent, $form);
		
		if (!$fieldNode)
		{
			return $fieldNode;
		}
                
		$fieldNode->setAttribute('type', 'subform');
		$fieldNode->setAttribute('filter','raw');
		foreach(array('language','customtemplate','template','subform_layout') as $name) {
			$fieldNode->removeAttribute($name);
		}
		$formsource = $field->fieldparams->get('formsource','plugins/fields/xmlform/forms/defaultform.xml');
		if(
				!file_exists(JPATH_ROOT.'/'.$formsource) || 
				!in_array(finfo_file(finfo_open(FILEINFO_MIME_TYPE),JPATH_ROOT.'/'.$formsource),array('application/xml','text/xml'))
		) {
			$formsource = 'plugins/fields/xmlform/forms/defaultform.xml';
		}
                
		$basename = str_replace('.xml','',basename($formsource));
		if((int)$field->fieldparams->get('language',0)) {
			$lang = Factory::getLanguage();
			$language = $basename;
			$path = JPATH_ROOT.'/'.dirname($formsource);
			$lang->load($language,$path);
		}
                
		$fieldNode->setAttribute('formsource',$formsource);
		
		if(!$field->fieldparams->get('min',0)) $fieldNode->removeAttribute('min');
		if(!$field->fieldparams->get('max',0)) $fieldNode->removeAttribute('max');
                $layout = $field->fieldparams->get('subform_layout','joomla.form.field.subform.default');
		$fieldNode->setAttribute('layout',$layout);
		if(
			$field->fieldparams->get('multiple','false') === 'false' || 
			$layout === 'joomla.form.field.subform.default'
		) {
			$fieldNode->removeAttribute('layout');
		}
                
		return $fieldNode;
	}
            /**
     * Before prepares the field value.
     *
     * @param   string     $context  The context.
     * @param   \stdclass  $item     The item.
     * @param   \stdclass  $field    The field.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function onCustomFieldsBeforePrepareField($context, $item, $field)
    // public function onCustomFieldsBeforePrepareField($event)
    {
        // $context = $event->getArgument('context');
        // $item    = $event->getArgument('item');
        // $field   = $event->getArgument('field');
        // Check if the field should be processed by us
        if (!$this->isTypeSupported($field->type))
        {
            return;
        }

        // Check if the field value is an old (string) value
        $field->value = $this->checkValue($field->value);
        // use the field to determine which item properties are needed by the field renderer.
        if(strlen(trim($field->value['iteminfo']??''))) {
            $iteminfos = explode(',',$field->value['iteminfo']);
            $field->value['iteminfo'] = new \stdClass();
            foreach($iteminfos as $itemprop) {
                $field->value['iteminfo']->$itemprop = $item->$itemprop??'';
            }
        }
    }
    
        /**
     * Before prepares the field value.
     *
     * @param   string  $value  The value to check.
     *
     * @return  array  The checked value
     *
     * @since   4.0.0
     */
    private function checkValue($value)
    {
        $jsonvalue = json_decode($value, true);

        if (json_last_error() === JSON_ERROR_NONE)
        {
            return (array) $jsonvalue;
        }

        return $value;
    }
}
