<?php
/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Plugin\Fields\XMLForm\Extension\XMLFormHelper;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

$value = json_decode($field->value,true);

if ($value == '' || empty($value))
{
	return;
}

$formsource = $field->fieldparams->get('formsource','plugins/fields/xmlform/forms/defaultform.xml');
$basename = str_replace('.xml','',basename($formsource));
$dirname = dirname($formsource);
if((int)$field->fieldparams->get('language',0)) {
	$lang = Factory::getLanguage();
	$language = $basename;
	$lang->load($language,JPATH_ROOT.'/'.$dirname);
}

if((int)$field->fieldparams->get('template',0)) {
	$template = $basename.'.php';
	$file = JPATH_ROOT.'/'.$dirname.'/'.$template;
	if(file_exists($file)) {
		include($file);
	}
} else {
	if(is_array($value)) {
			$table = $value;
	} else {
			$table = array();
			foreach((array)json_decode($value) as $key=>$row) {
					$table[$key] = (array)$row;
			}
	}
	$headings = XMLFormHelper::tableHeadings($formsource);
	echo XMLFormHelper::table($headings,$table);
}