class plg_content_miniglobe{radius=64;depth=128;rootPath=Joomla.getOptions("system.paths").root;options={bumpmap:false,clouds:false,textureImage:"media/plg_content_miniglobe/images/default.webp",bumpmapImage:"media/plg_content_miniglobe/images/bumpmap.webp",cloudsImage:"media/plg_content_miniglobe/images/clouds.webp",brightness:1,speed:.005,markerColor:"#ff0000",markerSize:.3,markers:[],markersAJAX:false,markersAJAXInterval:0};group=null;globe=null;clouds=null;markers=[];container=null;camera=null;scene=null;renderer=null;constructor(container,options=null){if(options){Object.assign(this.options,options)}this.container=container;this.init()}init=async()=>{this.scene=new THREE.Scene;this.camera=new THREE.PerspectiveCamera(75,this.container.clientWidth/this.container.clientHeight,.1,1e3);this.camera.position.z=this.radius*2.1;this.renderer=new THREE.WebGLRenderer({alpha:true,preserveDrawingBuffer:true});this.renderer.setSize(this.container.clientWidth,this.container.clientHeight);this.container.appendChild(this.renderer.domElement);window.addEventListener("resize",this.onWindowResize.bind(this));await this.renderGlobe();if(this.options.markers&&this.options.markers.length){this.options.markers.forEach(marker=>{this.addMarker(marker.lat,marker.lon,marker.size,marker.color)})}this.animate();this.onWindowResize();this.container.dispatchEvent(new CustomEvent("miniglobe:initialized",{detail:{container:this.container}}))};renderGlobe=async texture=>{this.group=new THREE.Group;const ambientLight=new THREE.AmbientLight(16777215,this.options.brightness);this.scene.add(ambientLight);const globeGeometry=new THREE.SphereGeometry(this.radius,this.depth,this.depth);const globeTexture=await this.loadTexture(this.options.textureImage);globeTexture.colorSpace=THREE.SRGBColorSpace;globeTexture.wrapS=THREE.RepeatWrapping;globeTexture.wrapT=THREE.ClampToEdgeWrapping;globeTexture.offset.set(0,0);globeTexture.repeat.set(1,1);let materialOptions={map:globeTexture};if(this.options.bumpmap){const bumpTexture=await this.loadTexture(this.options.bumpmapImage);materialOptions.bumpMap=bumpTexture;materialOptions.bumpScale=.3}const globeMaterial=new THREE.MeshStandardMaterial(materialOptions);this.globe=new THREE.Mesh(globeGeometry,globeMaterial);this.group.add(this.globe);if(this.options.clouds){const cloudGeometry=new THREE.SphereGeometry(this.radius*1.005,this.depth,this.depth);const cloudTexture=await this.loadTexture(this.options.cloudsImage);const cloudMaterial=new THREE.MeshStandardMaterial({alphaMap:cloudTexture,transparent:true});this.clouds=new THREE.Mesh(cloudGeometry,cloudMaterial);this.group.add(this.clouds)}this.scene.add(this.group)};loadTexture=async path=>{const url=path.startsWith("http")?path:this.rootPath+"/"+path;let textureLoader=new THREE.TextureLoader;return new Promise(resolve=>{textureLoader.load(url,texture=>{resolve(texture)})})};addAJAXMarkers=async()=>{if(!this.options.markersAJAX)return;let url=this.options.markersAJAX;if(this.options.markersAJAX.substring(0,4)!=="http"){url=this.rootPath+"/"+this.options.markersAJAX}if(this.options.markersAJAXInterval&&parseInt(this.options.markersAJAXInterval)>0){setInterval(async()=>{let markers=await this.fetchAJAXMarkers(url);this.removeMarkers();this.processMarkersArray(markers)},parseInt(this.options.markersAJAXInterval)*1e3)}const markers=await this.fetchAJAXMarkers(url);this.processMarkersArray(markers)};processMarkersArray(markers){if(Array.isArray(markers)&&markers.length){markers.forEach(marker=>{this.addMarker(marker.lat,marker.lon,marker.size??false,marker.color??false)})}}fetchAJAXMarkers=async url=>{try{const response=await fetch(url,{method:"GET"});if(!response.ok){console.error("Error fetching markers:",response.statusText);return[]}const data=await response.json();return data}catch(error){console.error("Error fetching markers:",error);return[]}};addMarker(lat,lon,size=false,color=false){size=size?size:parseFloat(this.options.markerSize);color=color?color:this.options.markerColor;if(!lat||!lon)return;if(!this.globe)return;const depth=this.depth/2;const markerGeometry=new THREE.SphereGeometry(size*this.radius,depth,depth);const markerMaterial=new THREE.MeshBasicMaterial({color:color});const marker=new THREE.Mesh(markerGeometry,markerMaterial);marker.position.copy(this.latLonToVector3(lat,lon,this.radius*1.01));this.globe.add(marker);this.markers.push(marker)}removeMarkers(id=[]){if(Array.isArray(id)&&id.length){id.forEach(i=>{if(this.markers[i]){this.globe.remove(this.markers[i]);this.markers.splice(i,1)}})}else{if(parseInt(id)&&this.markers[parseInt(id)]){this.globe.remove(this.markers[parseInt(id)]);this.markers.splice(parseInt(id),1)}else{this.markers.forEach(marker=>{this.globe.remove(marker)});this.markers=[]}}}onWindowResize(){this.camera.aspect=this.container.clientWidth/this.container.clientHeight;this.camera.updateProjectionMatrix();this.renderer.setSize(this.container.clientWidth,this.container.clientWidth)}animate(){requestAnimationFrame(this.animate.bind(this));this.group.rotation.y+=parseFloat(this.options.speed);if(this.clouds){this.clouds.rotation.y-=parseFloat(this.options.speed)/10}this.renderer.render(this.scene,this.camera)}latLonToVector3(lat,lon,radius){const phi=(90-lat)*Math.PI/180;const theta=(lon+180)*Math.PI/180;const x=-radius*Math.sin(phi)*Math.cos(theta);const z=radius*Math.sin(phi)*Math.sin(theta);const y=radius*Math.cos(phi);return new THREE.Vector3(x,y,z)}}window.addEventListener("DOMContentLoaded",()=>{const globes=document.querySelectorAll(".plg_content_miniglobe");globes.forEach(globe=>{const options=JSON.parse(JSON.stringify(Joomla.getOptions("plg_content_miniglobe")));const optionNames=["bumpmap","clouds","textureImage","bumpmapImage","cloudsImage","brightness","speed","markerColor","markerSize","markers","markersAJAX","markersAJAXInterval"];optionNames.forEach(optionName=>{if(!globe.dataset[optionName.toLowerCase()])return;let value=globe.dataset[optionName.toLowerCase()]??null;if(value===null)return;switch(optionName){case"bumpmap":case"clouds":value=parseInt(value)?true:false;break;case"brightness":case"speed":case"markerSize":value=parseFloat(value);break;case"markers":try{markers=JSON.parse(value);if(Array.isArray(markers)){value=[];markers.forEach(marker=>{let item={lat:marker[0],lon:marker[1],size:marker[2]??false,color:marker[3]??false};value.push(item)})}}catch(e){console.error("Invalid JSON for markers:",value);value=[]}break;case"markersAJAX":globe.addEventListener("miniglobe:initialized",async event=>{const container=event.detail.container;const globeInstance=container.MiniGlobe;if(!globeInstance)return;await globeInstance.addAJAXMarkers()});break}options[optionName]=value});globe.MiniGlobe=new plg_content_miniglobe(globe,options)})});
