<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Content\AgeOf\Extension;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Language\Text;
use Joomla\Plugin\Content\AgeOf\Extension\TagParser;

defined('_JEXEC') or die;

final class AgeOf extends CMSPlugin 
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     *
     * @since  3.9.0
     */
    protected $autoloadLanguage = true;    

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepare' => 'onContentPrepare',
		];
	}

    public function onContentPrepare($context, &$article, &$params, $page = 0) {
        if($context == 'com_finder.indexer' || Factory::getApplication()->isClient('administrator')) {
            return; // don't run in the admin interface
        }
		if (strpos($article->text, '{/ageof}') === false) {
            return true; // good reasons to exit early
        }             
        $tagparser = new TagParser('ageof');
        $tagparser->parse($article->text);
        $defaultlength=$this->params->get('length',2);
        foreach(['pastfuture'=>1,'pastprefix'=>'','pastsuffix'=>'','futureprefix'=>'','futuresuffix'=>''] as $param=>$default) {
            ${'default'.$param}=$this->params->get($param,$default);
        }
        foreach($tagparser->tags as $tag) {
            $process = true;
            $output = '';
            
            $now=new Date('now');
            $before=$tag->getParam('before',false);
            if($before !== false) {
                $before = new Date($before);
                // if($now >= $before) $process=false;
                $process = ($now < $before);
            }                    
            $after=$tag->getParam('after',false);
            if($after !== false) {
                $after = new Date($after);
                // if($now <= $after) $process=false;
                $process = ($now > $after);
            }
            
            if($process) {
                $interval = $this->_getAge(is_numeric($tag->content)?date('c',$tag->content):$tag->content);
                $format = $this->_format($interval,$tag->getParam('length',$defaultlength));
                if(count($format) > 1) {
                    $last = array_pop($format);
                    $format=implode(', ',$format).Text::_('PLG_CONTENT_AGEOF_AND').$last;
                } else {
                    $format = $format[0];
                }
                if($interval->invert) {
                    $prefix= $tag->getParam('pastprefix',$defaultpastprefix);
                    $suffix=($tag->getParam('pastfuture',$defaultpastfuture)?' '.Text::_('PLG_CONTENT_AGEOF_AGO'):'').$tag->getParam('pastsuffix',$defaultpastsuffix);
                } else {
                    $prefix= $tag->getParam('futureprefix',$defaultfutureprefix);
                    $suffix=($tag->getParam('pastfuture',$defaultpastfuture)?' '.Text::_('PLG_CONTENT_AGEOF_FROMNOW'):'').$tag->getParam('futuresuffix',$defaultfuturesuffix);
                }
                $output = $prefix.$interval->format($format).$suffix;
            }
            $article->text = $tag->replace($article->text,$output);
        }
    }
    private function _getAge($datestring) {
        $date = new Date($datestring);
        $now = new Date('now');
        return $now->diff($date); 
    }
    private function _format($interval,$length) { 
        $doPlural = function($count,$string){return 'PLG_CONTENT_AGEOF_'.($count>1?$string.'S':$string);}; 
        $format = array(); 
        foreach(array('y'=>'YEAR','m'=>'MONTH','d'=>'DAY','h'=>'HOUR','i'=>'MINUTE') as $key=>$value) {
            if($interval->$key !== 0) $format[] = '%'.$key.' '.Text::_($doPlural($interval->$key, $value));
        }
        if($interval->s !== 0) { 
            if(!count($format)) return array(Text::_('PLG_CONTENT_AGEOF_LESSTHANMINUTE')); 
        } else { 
            $format[] = "%s ".Text::_($doPlural($interval->s, 'SECOND'));
        } 
        $format = array_chunk($format,$length);
        return $format[0]; 
    }

}
