<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Contact.validemail
 *
 * @copyright   (C) 2023 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Cache\CacheControllerFactoryInterface;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\Contact\ValidEmail\Extension\ValidEmail;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.4.0
     */
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $cacheControllerFactory = $container->get(CacheControllerFactoryInterface::class);
                $plugin     = new ValidEmail(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('contact', 'validemail'),
                    $cacheControllerFactory
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};